/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauEntry;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.evvimport.bordereau.ChangeBordereauInvoiceNumberJob;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexTablePmListener;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;

public abstract class BordereauIndexTablePmBase
extends AbstractTableModel {
    private final ITableAdapter[] configs;
    private final SimpleDocument searchModel;
    private final ListenerList<IIndexTablePmListener> listeners = new ListenerList();
    private ListSelectionModel selectionModel;

    public BordereauIndexTablePmBase(SimpleDocument searchModel) {
        this.configs = BordereauEntry.tableConfig;
        this.searchModel = searchModel;
        this.addSearchListener();
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    protected void fireTableDataChangedRestoreSelection() {
        if (this.selectionModel == null) {
            this.fireTableDataChanged();
            return;
        }
        int currentSelection = this.selectionModel.getLeadSelectionIndex();
        this.fireTableDataChanged();
        if (this.getRowCount() == 0) {
            return;
        }
        currentSelection = currentSelection > this.getRowCount() - 1 ? this.getRowCount() - 1 : currentSelection;
        try {
            this.selectionModel.setSelectionInterval(currentSelection, currentSelection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addSearchListener() {
        this.searchModel.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e2) {
                BordereauIndexTablePmBase.this.notifySearchTextChanged(BordereauIndexTablePmBase.this.searchModel.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e2) {
                BordereauIndexTablePmBase.this.notifySearchTextChanged(BordereauIndexTablePmBase.this.searchModel.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e2) {
            }
        });
    }

    public void notifySearchNext(boolean backwards) {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.searchNext(backwards);
        }
    }

    private void notifySearchTextChanged(String text) {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.searchTextChanged(text);
        }
    }

    public void notifyOpenCurrentSending() {
        for (IIndexTablePmListener listener : this.listeners) {
            listener.openCurrentSending();
        }
    }

    @Override
    public int getColumnCount() {
        return this.configs.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.configs[columnIndex].getColType();
    }

    @Override
    public String getColumnName(int column) {
        return this.configs[column].getColName();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 10;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String value = aValue == null ? "" : aValue.toString();
        String mInvoice = columnIndex == 12 ? value : null;
        String zInvoice = columnIndex == 11 ? value : null;
        BordereauEntry entry = this.getIndexEntry(rowIndex);
        ChangeBordereauInvoiceNumberJob job = new ChangeBordereauInvoiceNumberJob(entry, mInvoice, zInvoice);
        Services.get(IBackendService.class).put(job);
    }

    public ITableAdapter[] getConfig() {
        return this.configs;
    }

    @Override
    public INode<?> getValueAt(int rowIndex, int columnIndex) {
        return this.configs[columnIndex].getValue(this.getIndexEntry(rowIndex));
    }

    public abstract BordereauEntry getIndexEntry(int var1);

    public Document getSearchModel() {
        return this.searchModel;
    }

    public void clearSearch() {
        this.searchModel.setText("");
    }

    public void add(IIndexTablePmListener listener) {
        this.listeners.add(listener);
    }

    public void filterReceipts(int row) {
        BordereauEntry selected = this.getIndexEntry(row);
        Services.get(IGuiService.class).selectImportTab(GuiService.ImportTab.receipts, selected.getBordereauNumber().getValue());
    }
}

