/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ReceiptEntry;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.index.IIndexChangeListener;
import ch.transsoft.edec.service.index.receipt.IReceiptService;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.evvimport.receipt.ReceiptIndexTablePmBase;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.sendinglist.IIndexSearchPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class ReceiptIndexTablePm
extends ReceiptIndexTablePmBase
implements IPm,
IIndexSearchPm,
IDisposable {
    private ReceiptIndex index;
    private final Disposables disposables = new Disposables();

    public ReceiptIndexTablePm(SimpleDocument searchModel) {
        super(searchModel);
        this.index = NodeFactory.create(ReceiptIndex.class);
        this.addListener();
    }

    public void initialize() {
        Services.get(IReceiptService.class).readIndex();
    }

    private void addListener() {
        this.disposables.add(Services.get(IReceiptService.class).add(new IIndexChangeListener<ReceiptEntry, ReceiptIndex>(){

            @Override
            public void changed(ReceiptIndex newIndex) {
                Check.assertNotNull(newIndex);
                ReceiptIndexTablePm.this.index = newIndex;
                ReceiptIndexTablePm.this.fireTableDataChangedRestoreSelection();
            }

            @Override
            public void clear() {
                ReceiptIndexTablePm.this.index = NodeFactory.create(ReceiptIndex.class);
                ReceiptIndexTablePm.this.fireTableDataChanged();
            }
        }));
    }

    @Override
    public int getRowCount() {
        return this.index.getEntryList().size();
    }

    @Override
    public ReceiptEntry getIndexEntry(int row) {
        return this.index.getEntryList().get(row);
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

