/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.imp;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.pm.imp.SendingInfo;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SendingList {
    public static final String MARKER_EXT = ".imported";
    private Map<Sending, File> map = new HashMap<Sending, File>();
    private List<SendingInfo> list = new ArrayList<SendingInfo>();
    private final Map<Sending, Boolean> cache = new HashMap<Sending, Boolean>();

    public int size() {
        return this.list.size();
    }

    public SendingInfo get(int index) {
        return this.list.get(index);
    }

    public boolean refresh(List<SendingInfo> newList) {
        this.map = new HashMap<Sending, File>();
        this.list = new ArrayList<SendingInfo>();
        this.clearCache();
        for (SendingInfo current : newList) {
            this.list.add(current);
            this.map.put(current.getSending(), current.getFile());
        }
        return true;
    }

    public void markAsImported(Sending sending, boolean value) {
        this.clearCache();
        File file = this.map.get(sending);
        if (file == null) {
            return;
        }
        File markerFile = this.getMarkerFile(file);
        if (!value) {
            markerFile.delete();
        } else {
            this.writeMarkerFile(markerFile);
        }
    }

    private void writeMarkerFile(File markerFile) {
        try {
            FileUtil.close(FileUtil.createFileWriter(markerFile));
        }
        catch (IOException e2) {
            Check.fail(e2);
        }
    }

    public void deleteFiles(Sending sending) {
        this.clearCache();
        File file = this.map.get(sending);
        File markerFile = this.getMarkerFile(file);
        if (!file.delete()) {
            Services.get(ILoggingService.class).logAndReport(Services.format(626, file.toString()));
        }
        if (!markerFile.delete()) {
            Services.get(ILoggingService.class).logAndReport(String.format(Services.format(626, markerFile.toString()), new Object[0]));
        }
    }

    public Boolean isImported(Sending sending) {
        Boolean result = this.cache.get(sending);
        if (result == null) {
            File file = this.map.get(sending);
            File markerFile = this.getMarkerFile(file);
            result = markerFile.exists();
            this.cache.put(sending, result);
        }
        return result;
    }

    private File getMarkerFile(File file) {
        String markerName = file.getName() + MARKER_EXT;
        return new File(file.getParent(), markerName);
    }

    private void clearCache() {
        this.cache.clear();
    }

    public void deleteMarked() {
        for (SendingInfo info : this.list) {
            if (!this.isImported(info.getSending()).booleanValue()) continue;
            this.deleteFiles(info.getSending());
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List<SendingInfo> getSendingInfos() {
        return this.list;
    }

    public int getIndexInfo(SendingInfo info) {
        return this.list.indexOf(info);
    }

    public List<SendingInfo> getSendingList() {
        return this.list;
    }
}

