/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.imp.table;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.imp.ReadImportsJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.pm.imp.SendingInfo;
import ch.transsoft.edec.ui.pm.imp.SendingList;
import ch.transsoft.edec.util.Check;
import java.io.File;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ImportTableModel
extends AbstractTableModel {
    private static String[] columnNames = new String[]{Services.getText(1532), Services.getText(1533), Services.getText(1534), Services.getText(1535), Services.getText(1536), Services.getText(1574), Services.getText(1576), Services.getText(1578), Services.getText(1537), Services.getText(210), Services.getText(600)};
    private static final int MARKER_COL = 9;
    private static final int INFO_COL = 10;
    private SendingList imports = new SendingList();

    public ImportTableModel() {
        this.refresh(false);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 9) {
            return true;
        }
        return columnIndex == 10;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 9) {
            return Boolean.class;
        }
        if (columnIndex == 10) {
            return SendingInfo.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.imports.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SendingInfo info = this.imports.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return info.getFile().getName();
            }
            case 1: {
                return info.getSending().getGoodsDeclaration().getConsignee().getId();
            }
            case 2: {
                return info.getSending().getGoodsDeclaration().getConsignee().getName().getValue();
            }
            case 3: {
                return info.getSending().getGoodsDeclaration().getConsignee().getCity().getValue();
            }
            case 4: {
                return info.getSending().getGoodsDeclaration().getConsignee().getCountry().getValue().getDesc();
            }
            case 5: {
                return this.getDeliveryId(info);
            }
            case 6: {
                return this.getDeliveryName(info);
            }
            case 7: {
                return info.getSending().getGoodsDeclaration().getCarrier().getName().getValue();
            }
            case 8: {
                return info.getSending().getItemList().getGoodsItems().size();
            }
            case 9: {
                return this.imports.isImported(info.getSending());
            }
            case 10: {
                return info;
            }
        }
        throw Check.fail("Unexpected columnIndex");
    }

    private String getDeliveryName(SendingInfo info) {
        Address delivery = info.getSending().getGoodsDeclaration().getDelivery();
        if (!delivery.isEnabled()) {
            return "";
        }
        return delivery.getName().getValue();
    }

    private String getDeliveryId(SendingInfo info) {
        Address delivery = info.getSending().getGoodsDeclaration().getDelivery();
        if (!delivery.isEnabled()) {
            return "";
        }
        return delivery.getId().getValue();
    }

    public void refresh(boolean force) {
        File importDir = Services.get(IConfigService.class).getImportDir(false);
        Services.get(IBackendService.class).put(new ReadImportsJob(importDir, this, force));
    }

    public void setSendingList(List<SendingInfo> newList, boolean force) {
        if (!force && this.imports.getSendingList() != null && this.imports.getSendingList().equals(newList)) {
            return;
        }
        this.imports.refresh(newList);
        this.fireTableDataChanged();
    }

    public SendingInfo getSendingInfo(int i2) {
        return this.imports.get(i2);
    }

    public void markAsImported(Sending sending) {
        this.imports.markAsImported(sending, true);
        this.fireTableDataChanged();
    }

    public void deleteAllMarked() {
        if (this.imports.isEmpty()) {
            return;
        }
        this.imports.deleteMarked();
        this.refresh(false);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 9) {
            return;
        }
        Sending sending = this.imports.get(rowIndex).getSending();
        this.imports.markAsImported(sending, (Boolean)aValue);
    }

    public List<SendingInfo> getSendingInfos() {
        return this.imports.getSendingInfos();
    }

    public int getIndex(SendingInfo info) {
        return this.imports.getIndexInfo(info);
    }
}

