/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.model;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.IBooleanPm;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.JToggleButton;

public class BooleanPm
extends JToggleButton.ToggleButtonModel
implements IDisposable,
IBooleanPm {
    private final BooleanNode node;
    private final Disposables disposables = new Disposables();
    private final ListenerList<IPmListener> listeners = new ListenerList();

    public BooleanPm(BooleanNode node) {
        Check.assertNotNull(node);
        this.node = node;
        this.setSelected(node.getValue());
        this.addPmListener();
        this.disposables.add(node.addChangeListener(this.createNodeListener()));
    }

    @Override
    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.node.addErrorListener(listener));
    }

    private IChangeListener createNodeListener() {
        return (source, info) -> this.setSelected(this.node.getValue());
    }

    private void addPmListener() {
        this.addChangeListener(e2 -> this.node.setValue(this.isSelected()));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.node.getErrorInfo();
    }

    public void add(IPmListener listener) {
        this.listeners.add(listener);
    }
}

