/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.model;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.DateNode;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.util.DateUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.util.Date;

public class DatePm
extends SimpleDocument
implements IDisposable {
    private final DateNode node;
    private final Disposables disposables = new Disposables();
    private boolean enabled = true;
    private final ListenerList<IPmListener> listeners = new ListenerList();

    public DatePm(DateNode node) {
        this.node = node;
        this.setValue(node);
        this.addListener();
    }

    private void setValue(DateNode node) {
        if (!node.isInitialized()) {
            this.setText("");
            return;
        }
        this.setText(DateUtil.getDateFormat().format(node.getValue()));
    }

    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.node.addErrorListener(listener));
    }

    private void addListener() {
        this.disposables.add(this.node.addChangeListener(this.createNodeListener()));
    }

    private IChangeListener createNodeListener() {
        return (source, info) -> this.setValue(this.node);
    }

    public boolean isMandatory() {
        return this.node.isMandatory();
    }

    public void triggerDataChanged() {
        this.node.setValue(this.getText(), true);
        if (!this.node.isInitialized()) {
            this.setText("");
        }
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.node.getErrorInfo();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        for (IPmListener listener : this.listeners) {
            listener.enabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void add(IPmListener listener) {
        this.listeners.add(listener);
    }

    public void setNow() {
        this.node.setValue(new Date());
    }
}

