/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.model;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.EnumNode;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.ui.pm.model.ISelectionPm;
import ch.transsoft.edec.util.ReflectionUtil;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.ListenerList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class EnumPm<T extends Enum<T>>
implements ISelectionPm<T> {
    private final DefaultComboBoxModel<T> model = new DefaultComboBoxModel();
    private final EnumNode<T> node;
    private final Disposables disposables = new Disposables();
    private boolean enabled = true;
    private final ListenerList<IPmListener> listeners = new ListenerList();

    public EnumPm(EnumNode<T> node) {
        this.node = node;
        for (Enum current : (Enum[])ReflectionUtil.getTypedClass(node.getValue()).getEnumConstants()) {
            this.model.addElement(current);
        }
        this.setSelectedItem(node.getValue());
        this.addPmListener();
        this.addNodeListener();
    }

    @Override
    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.node.addErrorListener(listener));
    }

    private void addNodeListener() {
        this.disposables.add(this.node.addChangeListener((source, info) -> this.handleNodeChanged()));
    }

    private void handleNodeChanged() {
        this.setSelectedItem(this.node.getValue());
    }

    private void addPmListener() {
        this.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                EnumPm.this.handlePmChange();
            }
        });
    }

    private void handlePmChange() {
        this.node.setValue((Enum)this.getSelectedItem());
    }

    @Override
    public boolean isMandatory() {
        return this.node.isMandatory();
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.node.getErrorInfo();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        for (IPmListener listener : this.listeners) {
            listener.enabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void add(IPmListener listener) {
        this.listeners.add(listener);
    }

    public void add(IChangeListener listener) {
        this.disposables.add(this.node.addChangeListener(listener));
    }

    public Enum<?> getCurrentValue() {
        return this.node.getValue();
    }

    public boolean isInitialized() {
        return true;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.model.setSelectedItem(anItem);
    }

    @Override
    public Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    @Override
    public int getSize() {
        return this.model.getSize();
    }

    @Override
    public T getElementAt(int index) {
        return (T)((Enum)this.model.getElementAt(index));
    }

    @Override
    public void addListDataListener(ListDataListener l2) {
        this.model.addListDataListener(l2);
    }

    @Override
    public void removeListDataListener(ListDataListener l2) {
        this.model.removeListDataListener(l2);
    }
}

