/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.model;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.IPrimitive;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.infra.node.list.ListElementAdded;
import ch.transsoft.edec.model.infra.node.list.ListElementMoved;
import ch.transsoft.edec.model.infra.node.list.ListElementRemoved;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.ui.gui.control.table.DeleteButton;
import ch.transsoft.edec.ui.pm.model.IIndexConverter;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class TablePm<T extends ListEntry<T>>
extends AbstractTableModel
implements ListSelectionListener,
IDisposable {
    private final ListenerList<ITableListener> tableListeners = new ListenerList();
    private final ListenerList<ISelectionListener<T>> selectionListeners = new ListenerList();
    protected final ListNode<T> listNode;
    protected final Class<T> type;
    protected T emptyLine;
    private IDisposable emptyLineLIstenerHandle;
    private final Disposables disposables = new Disposables();
    protected T selectedItem;
    private final Map<Integer, DeleteButton> deleteButtons = new HashMap<Integer, DeleteButton>();
    private final ITableAdapter[] configs;
    private T lastSelectedItem = null;
    private IIndexConverter indexConverter;
    private boolean stateTableUpdating;
    private boolean stateValueUpdating;
    private boolean stateRowMoving;

    public TablePm(ListNode<T> listNode, Class<T> type, ITableAdapter[] configs) {
        Check.assertNotNull(configs);
        this.listNode = listNode;
        this.type = type;
        this.configs = configs;
        this.createEmptyLine();
        this.addEmptyLineListener();
        this.disposables.add(this.addNodeListeners());
    }

    public IIndexConverter getIndexConverter() {
        return this.indexConverter;
    }

    public void setIndexConverter(IIndexConverter indexConverter) {
        this.indexConverter = indexConverter;
    }

    private IDisposable addNodeListeners() {
        return this.listNode.addChangeListener((source, info) -> {
            if (source == this.listNode) {
                if (info instanceof ListElementAdded) {
                    this.handleElementAdded((ListElementAdded)info);
                } else if (info instanceof ListElementRemoved) {
                    this.handleElementRemoved((ListElementRemoved)info);
                } else if (info instanceof ListElementMoved) {
                    this.handleElementMoved((ListElementMoved)info);
                }
                return;
            }
            T child = this.getChild(source);
            int index = this.listNode.indexOf(child);
            if (index < 0) {
                Check.fail("not a child: " + source.getPath());
            }
            this.fireTableRowsUpdated(index, index);
        });
    }

    private void handleElementRemoved(ListElementRemoved info) {
        int index = this.convertModelIndexToRowIndex(info.getIndex());
        int newSelection = this.getRowCount() == index + 1 && this.getRowCount() > 1 ? index - 1 : index;
        this.fireTableRowsDeleted(info.getIndex(), info.getIndex());
        this.notifySelectRow(this.convertRowIndexToModelIndex(newSelection));
    }

    private void handleElementMoved(ListElementMoved info) {
        this.stateRowMoving = true;
        this.fireTableRowsUpdated(info.getFrom(), info.getTo());
        this.notifySelectRow(info.getTo());
        this.stateRowMoving = false;
    }

    private void handleElementAdded(ListElementAdded info) {
        this.stateTableUpdating = true;
        this.fireTableRowsInserted(info.getIndex(), info.getIndex());
        this.stateTableUpdating = false;
        this.notifySelectRow(info.getIndex());
        this.notifyScrollToElement(info.getIndex());
    }

    private T getChild(INode<?> source) {
        INode<?> current = source;
        while (current.getParent() != this.listNode) {
            current = current.getParent();
        }
        return (T)((ListEntry)current);
    }

    private void addEmptyLineListener() {
        this.emptyLineLIstenerHandle = ((NodeBase)this.emptyLine).addChangeListener((source, info) -> this.addNewLine(false));
    }

    protected void addNewLine(boolean addButton) {
        this.emptyLineLIstenerHandle.dispose();
        if (!this.configureEmptyLine(this.emptyLine, addButton)) {
            this.addEmptyLineListener();
            return;
        }
        T newLine = this.emptyLine;
        this.createEmptyLine();
        this.addEmptyLineListener();
        this.listNode.add(newLine);
    }

    private void createEmptyLine() {
        this.emptyLine = (ListEntry)NodeFactory.create(this.type);
    }

    protected boolean configureEmptyLine(T newRow, boolean addButton) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return this.configs.length + 1;
    }

    @Override
    public int getRowCount() {
        return this.listNode.size() + 1;
    }

    @Override
    public IPrimitive<?> getValueAt(int rowIndex, int columnIndex) {
        if (this.isManipulatorCol(columnIndex)) {
            return this.isLastRow(rowIndex) ? null : this.getDeleteButton(rowIndex);
        }
        if (rowIndex == this.listNode.size()) {
            return this.getValue((ModelNode<?>)this.emptyLine, columnIndex - 1);
        }
        return this.getValue((ModelNode<?>)this.listNode.get(rowIndex), columnIndex - 1);
    }

    private IPrimitive<?> getValue(ModelNode<?> parent, int index) {
        return (IPrimitive)this.configs[index].getValue(parent);
    }

    private boolean isLastRow(int rowIndex) {
        return rowIndex == this.listNode.size();
    }

    private boolean isManipulatorCol(int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.isManipulatorCol(columnIndex)) {
            return DeleteButton.class;
        }
        return this.configs[columnIndex - 1].getColType();
    }

    @Override
    public String getColumnName(int column) {
        if (this.isManipulatorCol(column)) {
            return "";
        }
        return this.configs[column - 1].getColName();
    }

    private IPrimitive<?> getDeleteButton(int rowIndex) {
        DeleteButton result = this.deleteButtons.get(rowIndex);
        if (result == null) {
            result = new DeleteButton();
            this.deleteButtons.put(rowIndex, result);
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.isManipulatorCol(columnIndex)) {
            return true;
        }
        return this.configs[columnIndex - 1].isEditable();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.stateRowMoving) {
            return;
        }
        this.stateValueUpdating = true;
        this.getValueAt(rowIndex, columnIndex).setValue(aValue, true);
        this.stateValueUpdating = false;
    }

    private void notifySelectionChanged(T t, boolean isEmptyLine, boolean sameItem) {
        for (ISelectionListener<T> listener : this.selectionListeners) {
            listener.selectionChanged(t, isEmptyLine, sameItem);
        }
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public final void mouseClicked(int row, int col, int clickCount) {
        row = this.convertRowIndexToModelIndex(row);
        this.handleMouseClicked(row, col, clickCount);
        if (row == -1) {
            return;
        }
        if (!this.isManipulatorCol(col)) {
            return;
        }
        if (this.isLastRow(row)) {
            this.addNewLine(true);
            return;
        }
        this.listNode.remove(row);
    }

    protected void handleMouseClicked(int row, int col, int clickCount) {
    }

    public IDisposable addSelectionListener(ISelectionListener<T> listener) {
        return this.selectionListeners.add(listener);
    }

    public IDisposable addTableListener(ITableListener listener) {
        return this.tableListeners.add(listener);
    }

    @Override
    public void valueChanged(ListSelectionEvent e2) {
        if (this.stateTableUpdating) {
            return;
        }
        if (this.stateValueUpdating) {
            return;
        }
        int selectionIndex = ((ListSelectionModel)e2.getSource()).getAnchorSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        this.selectedItem = (selectionIndex = this.convertRowIndexToModelIndex(selectionIndex)) == this.listNode.size() || this.listNode.isEmpty() ? this.emptyLine : this.listNode.get(selectionIndex);
        boolean isEmptyLine = this.selectedItem == this.emptyLine;
        boolean sameItem = this.selectedItem == this.lastSelectedItem;
        this.notifySelectionChanged(this.selectedItem, isEmptyLine, sameItem);
        this.lastSelectedItem = this.selectedItem;
    }

    private int convertModelIndexToRowIndex(int index) {
        if (this.getIndexConverter() == null) {
            return index;
        }
        return this.getIndexConverter().convertModelIndexToRowIndex(index);
    }

    private int convertRowIndexToModelIndex(int index) {
        if (this.getIndexConverter() == null) {
            return index;
        }
        return this.getIndexConverter().convertRowIndexToModelIndex(index);
    }

    public ITableAdapter[] getConfig() {
        return this.configs;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
        this.emptyLineLIstenerHandle.dispose();
    }

    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.listNode.addErrorListener(listener));
    }

    public void addEntry(T entry) {
        this.listNode.add(entry);
    }

    private void notifySelectRow(int index) {
        index = this.convertModelIndexToRowIndex(index);
        for (ITableListener listener : this.tableListeners) {
            listener.selectRow(index);
        }
    }

    private void notifyScrollToElement(int index) {
        for (ITableListener listener : this.tableListeners) {
            listener.scrollToRow(this.convertModelIndexToRowIndex(index));
        }
    }

    protected ListNode<T> getListNode() {
        return this.listNode;
    }

    public boolean isEmpty() {
        return this.listNode.isEmpty();
    }

    public List<Action> getContextMenu() {
        return new ArrayList<Action>();
    }

    public boolean isEmptyLine(T line) {
        return this.emptyLine == line;
    }

    public static interface ISelectionListener<T extends ListEntry<T>> {
        public void selectionChanged(T var1, boolean var2, boolean var3);
    }

    public static interface ITableListener {
        public void selectRow(int var1);

        public void scrollToRow(int var1);
    }
}

