/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.forms;

import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.ui.pm.sending.forms.PagePm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

public class FormPm
implements IDisposable {
    private final IFormDesc formDesc;
    private final List<PagePm> pages = new ArrayList<PagePm>();
    private final Sending sending;
    private final List<IFormPageDesc> variants;
    private final Disposables disposables = new Disposables();
    private final BoundedRangeModel zoomSliderModel = new DefaultBoundedRangeModel(100, 0, 50, 200);
    private final ListenerList<PagePm.PagePmListener> guiRecreationListeners = new ListenerList();

    public FormPm(IFormDesc formDesc, Sending sending) {
        this.formDesc = formDesc;
        this.sending = sending;
        this.variants = formDesc.getFrontPages();
        for (IFormPageDesc variant : this.variants) {
            PagePm pagePm = new PagePm(this, variant, sending, formDesc);
            this.addPage(pagePm);
        }
        this.addListeners();
        if (formDesc.hasBackPage()) {
            this.addPage(new PagePm(this, formDesc.getBackPage(), sending, formDesc, this.pages.get(0).getDataContext()));
        }
    }

    private void addPage(PagePm pagePm) {
        this.pages.add(pagePm);
        this.disposables.add(pagePm);
    }

    public List<PagePm> getFormSides() {
        return this.pages;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public void variantChanged(int selectedIndex) {
        if (this.variants.size() == 1) {
            this.pages.get(selectedIndex).updateState();
            return;
        }
        if (selectedIndex >= this.variants.size()) {
            return;
        }
        this.sending.getForms().setVariantId(this.formDesc, this.variants.get(selectedIndex));
    }

    public int getSelectedVariant() {
        return this.sending.getForms().getSelectedVariantIndex(this.formDesc, this.variants);
    }

    public Disposables getDisposables() {
        return this.disposables;
    }

    private void addListeners() {
        this.zoomSliderModel.addChangeListener(e2 -> {
            BoundedRangeModel slider = (BoundedRangeModel)e2.getSource();
            if (!slider.getValueIsAdjusting()) {
                this.notifyGuiRecreationListeners();
            }
        });
    }

    private void notifyGuiRecreationListeners() {
        for (PagePm.PagePmListener listener : this.guiRecreationListeners) {
            listener.update();
        }
    }

    public IDisposable addGuiRecreationListener(PagePm.PagePmListener listener) {
        return this.guiRecreationListeners.add(listener);
    }

    public BoundedRangeModel getZoomSliderModel() {
        return this.zoomSliderModel;
    }

    public double getZoomScale() {
        return (double)this.getZoomSliderModel().getValue() / 100.0;
    }

    public void setZoomScale(double currentZoom) {
        this.getZoomSliderModel().setValue((int)(currentZoom * 100.0));
    }
}

