/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.forms;

import ch.transsoft.edec.model.infra.event.IChangeInfo;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.service.form.IFormDesc;
import ch.transsoft.edec.service.form.IFormPageDesc;
import ch.transsoft.edec.service.form.desc.NodeDesc;
import ch.transsoft.edec.service.form.render.DataContext;
import ch.transsoft.edec.service.form.render.IUnitConverter;
import ch.transsoft.edec.service.form.render.RenderContext;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.gui.sending.forms.PageContentPanel;
import ch.transsoft.edec.ui.pm.sending.forms.FormPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.awt.Color;
import java.awt.event.MouseWheelEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.text.Document;

public class PagePm
implements IDisposable {
    private final ListenerList<PagePmListener> listeners = new ListenerList();
    private final FormPm parent;
    private final IFormPageDesc formPage;
    private final SimpleDocument pageNumber = new SimpleDocument();
    private final ButtonModel back = new DefaultButtonModel();
    private final ButtonModel forward = new DefaultButtonModel();
    private final DataContext dataContext;
    private final Sending sending;
    private ItemList goodsItems;
    private final IFormDesc formDesc;
    private final Disposables disposables = new Disposables();

    public PagePm(FormPm parent, IFormPageDesc formSideDesc, Sending sending, IFormDesc formDesc) {
        this(parent, formSideDesc, sending, formDesc, formDesc.createDataContext(sending, formSideDesc));
    }

    public PagePm(FormPm parent, IFormPageDesc formSideDesc, Sending sending, IFormDesc formDesc, DataContext dataContext) {
        this.parent = parent;
        this.formPage = formSideDesc;
        this.sending = sending;
        this.formDesc = formDesc;
        this.goodsItems = formDesc.getGoodsItems(sending);
        this.dataContext = dataContext;
        this.updateState();
        this.addListener();
    }

    private void addListener() {
        this.disposables.add(this.sending.getItemList().addChangeListener(this::numberOfGoodsItemsChanged));
        this.back.addActionListener(e2 -> {
            this.dataContext.decrementCurrentPart();
            this.updateState();
            this.notifyListeners();
        });
        this.forward.addActionListener(e2 -> {
            this.dataContext.incrementCurrentPart();
            this.updateState();
            this.notifyListeners();
        });
        BooleanNode descriptionEnglish = this.sending.getForms().findForm(this.formDesc.getId()).getDescriptionInEnglish();
        if (descriptionEnglish != null) {
            this.disposables.add(descriptionEnglish.addChangeListener((source, info) -> {
                this.dataContext.recompute(source, info);
                this.updateState();
            }));
        }
    }

    private void numberOfGoodsItemsChanged(INode<?> source, IChangeInfo info) {
        this.goodsItems = this.formDesc.getGoodsItems(this.sending);
        this.dataContext.recompute(this.goodsItems, source, info);
        this.updateState();
    }

    private void notifyListeners() {
        for (PagePmListener listener : this.listeners) {
            listener.update();
        }
    }

    public void updateState() {
        this.back.setEnabled(this.dataContext.getCurrentPage() > 1);
        this.forward.setEnabled(this.dataContext.getCurrentPage() < this.dataContext.getPageCount());
        this.pageNumber.setText(this.dataContext.getCurrentPage() + "/" + this.dataContext.getPageCount());
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public String getName() {
        return this.formPage.getGuiName();
    }

    public Sending getSending() {
        return this.sending;
    }

    public void render(RenderContext renderContext) {
        this.formPage.render(this.sending, this.goodsItems, this.dataContext, renderContext);
    }

    public Document getPageNumberModel() {
        return this.pageNumber;
    }

    public ButtonModel getForwardButtonModel() {
        return this.forward;
    }

    public ButtonModel getBackButtonModel() {
        return this.back;
    }

    public IFormPageDesc getFormPage() {
        return this.formPage;
    }

    public ListNode<NodeDesc> getNodes() {
        return this.formPage.getNodes();
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public IDisposable add(PagePmListener listener) {
        return this.listeners.add(listener);
    }

    public void addControls(PageContentPanel pageContentPanel, IUnitConverter c2) {
        this.formPage.addControls(this.disposables, this.sending, pageContentPanel, c2);
    }

    public void addStaticControls(PageContentPanel pageContentPanel, IUnitConverter c2) {
        this.formPage.addStaticControls(pageContentPanel, c2);
    }

    public ItemList getGoodsItems() {
        return this.goodsItems;
    }

    public Color getTextBackgroundColor() {
        return this.getFormPage().getTextBackgroundColor();
    }

    public void addDisposable(IDisposable disposable) {
        this.disposables.add(disposable);
    }

    public BoundedRangeModel getZoomSliderModel() {
        return this.parent.getZoomSliderModel();
    }

    public double getZoomScale() {
        return this.parent.getZoomScale();
    }

    public void adjustZoomByMouseWheel(MouseWheelEvent e2) {
        int percentsPerNotch = 10;
        int notches = -e2.getWheelRotation();
        BoundedRangeModel slider = this.getZoomSliderModel();
        int previousZoom = slider.getValue();
        double newZoom = previousZoom + notches * 10;
        slider.setValue((int)newZoom);
    }

    public static interface PagePmListener {
        public void update();
    }
}

