/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.heading;

import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.StringPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.awt.Color;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class BondedWarehouseAddressPm
implements IPm,
IDisposable {
    private StringPm name;
    private StringPm street;
    private StringPm addressSupplement1;
    private StringPm addressSupplement2;
    private StringPm postalCode;
    private StringPm city;
    private SelectionPm country;
    private final Address address;
    private final Border titleBorder;
    private Disposables disposables = new Disposables();

    public BondedWarehouseAddressPm(Address address, String title) {
        this.address = address;
        this.name = new StringPm(address.getName());
        this.street = new StringPm(address.getStreet());
        this.addressSupplement1 = new StringPm(address.getAddressSupplement1());
        this.addressSupplement2 = new StringPm(address.getAddressSupplement2());
        this.postalCode = new StringPm(address.getPostalCode());
        this.city = new StringPm(address.getCity());
        this.country = new SelectionPm(address.getCountry());
        this.titleBorder = new LineBorder(Color.LIGHT_GRAY, 1);
    }

    public StringPm getName() {
        return this.name;
    }

    public StringPm getStreet() {
        return this.street;
    }

    public StringPm getAddressSupplement1() {
        return this.addressSupplement1;
    }

    public StringPm getAddressSupplement2() {
        return this.addressSupplement2;
    }

    public StringPm getPostalCode() {
        return this.postalCode;
    }

    public StringPm getCity() {
        return this.city;
    }

    public SelectionPm getCountry() {
        return this.country;
    }

    public void apply(Address t) {
        this.address.apply(t);
    }

    public Border getTitleBorder() {
        return this.titleBorder;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

