/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.heading;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.masterdata.Consignors;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.ui.action.MasterDataConsignorActionInComboBox;
import ch.transsoft.edec.ui.pm.sending.heading.PmBase;
import ch.transsoft.edec.util.MasterDataUtil;

public final class ConsignorPm
extends PmBase<Consignor> {
    public ConsignorPm(Consignor current) {
        super(current, Services.get(IActionService.class).getAction(MasterDataConsignorActionInComboBox.class));
        Consignors masterData = (Consignors)Services.get(IDataService.class).getMasterData(DataFiles.consignor).getCopy((ModelNode)null);
        this.populate(masterData.getConsignorList());
        this.addMasterDataListener();
        this.addConfigListener();
    }

    private void addConfigListener() {
        this.getDisposables().add(Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void rootChanged() {
                Services.get(IDataService.class).loadData(DataFiles.consignor, false);
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void configurationChanged() {
            }
        }));
    }

    private void addMasterDataListener() {
        this.getDisposables().add(Services.get(IDataService.class).addDataListener(DataFiles.consignor, consignors -> {
            MasterDataUtil.adjustData(Services.get(IAppService.class).getCurrentSending(), consignors);
            this.populate(consignors.getConsignorList());
        }));
    }

    @Override
    protected Consignor getEmptyObject() {
        return NodeFactory.create(Consignor.class);
    }
}

