/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.heading;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.masterdata.Declarants;
import ch.transsoft.edec.model.sending.goodsdeclaration.Declarant;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.masterdata.DataFiles;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.ui.action.MasterDataDeclarantActionInComboBox;
import ch.transsoft.edec.ui.pm.sending.heading.PmBase;
import ch.transsoft.edec.util.MasterDataUtil;

public final class DeclarantPm
extends PmBase<Declarant> {
    public DeclarantPm(Declarant current) {
        super(current, Services.get(IActionService.class).getAction(MasterDataDeclarantActionInComboBox.class));
        Declarants masterData = (Declarants)Services.get(IDataService.class).getMasterData(DataFiles.declarant).getCopy((ModelNode)null);
        this.populate(masterData.getDeclarantList());
        this.addMasterDataListener();
        this.addConfigListener();
    }

    private void addConfigListener() {
        this.getDisposables().add(Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void rootChanged() {
                Services.get(IDataService.class).loadData(DataFiles.declarant, false);
            }

            @Override
            public void modeChanged(boolean isDemo) {
            }

            @Override
            public void configurationChanged() {
            }
        }));
    }

    private void addMasterDataListener() {
        this.getDisposables().add(Services.get(IDataService.class).addDataListener(DataFiles.declarant, declarants -> {
            MasterDataUtil.adjustData(Services.get(IAppService.class).getCurrentSending(), declarants);
            this.populate(declarants.getDeclarantList());
        }));
    }

    @Override
    protected Declarant getEmptyObject() {
        return NodeFactory.create(Declarant.class);
    }
}

