/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.heading;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.IPmListener;
import ch.transsoft.edec.ui.pm.model.ISelectionPm;
import ch.transsoft.edec.util.disposable.Disposables;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class PmBase<T extends ListEntry<T>>
implements ISelectionPm<Object> {
    private final DefaultComboBoxModel<Object> model = new DefaultComboBoxModel();
    protected final T current;
    private final Action action;
    private final Disposables disposables = new Disposables();
    private boolean populating = false;
    private ListNode<T> itemList;

    public PmBase(T current, Action action) {
        this.current = current;
        this.action = action;
        this.addPmListener();
        this.addDataListener();
    }

    private void addDataListener() {
        this.disposables.add(((NodeBase)this.current).addChangeListener((source, info) -> this.populate(this.itemList)));
    }

    protected void addPmListener() {
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e2) {
            }

            @Override
            public void intervalAdded(ListDataEvent e2) {
            }

            @Override
            public void contentsChanged(ListDataEvent e2) {
                PmBase.this.handlePmChange();
            }
        });
    }

    private void handlePmChange() {
        if (this.populating) {
            return;
        }
        if (this.getSelectedItem() == this.action) {
            this.setSelection(this.itemList);
            this.action.actionPerformed(null);
            return;
        }
        ListEntry item = (ListEntry)this.getSelectedItem();
        if (item == null) {
            return;
        }
        this.current.apply((ListEntry)item);
    }

    @Override
    public Object getSelectedItem() {
        return this.model.getSelectedItem();
    }

    protected void populate(ListNode<T> itemList) {
        this.itemList = itemList;
        this.populating = true;
        this.model.removeAllElements();
        if (!itemList.isEmpty()) {
            this.model.addElement(this.getEmptyObject());
        }
        for (ListEntry item : itemList) {
            this.model.addElement(item);
        }
        this.model.addElement(this.action);
        this.setSelection(itemList);
        this.populating = false;
    }

    protected abstract T getEmptyObject();

    private void setSelection(ListNode<T> itemList) {
        for (ListEntry item : itemList) {
            if (!item.isEquals(this.current)) continue;
            this.model.setSelectedItem(item);
            return;
        }
        this.model.setSelectedItem(this.current);
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    @Override
    public void addErrorListener(IErrorListener iErrorListener) {
        this.disposables.add(((NodeBase)this.current).addErrorListener(iErrorListener));
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return ((NodeBase)this.current).getErrorInfo();
    }

    @Override
    public void add(IPmListener listener) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected Disposables getDisposables() {
        return this.disposables;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.model.setSelectedItem(anItem);
    }

    @Override
    public int getSize() {
        return this.model.getSize();
    }

    @Override
    public Object getElementAt(int index) {
        return this.model.getElementAt(index);
    }

    @Override
    public void addListDataListener(ListDataListener l2) {
        this.model.addListDataListener(l2);
    }

    @Override
    public void removeListDataListener(ListDataListener l2) {
        this.model.removeListDataListener(l2);
    }
}

