/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.ui.dialog.masterdata.IMasterdataPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.ConfirmationPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.GoodsDataPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.GoodsItemDetailPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.NonCustomsLawPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.NotificationPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.PermitsPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.ProducedDocumentPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.RefundPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.RepairAndRefinementPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.SensibleGoodsPm;
import ch.transsoft.edec.ui.pm.sending.itemlist.SpecialMentionsPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class GoodsItemPm
implements IMasterdataPm,
IDisposable {
    private final GoodsItem goodsItem;
    private final GoodsDataPm goodsData;
    private final ProducedDocumentPm producedDocument;
    private final PermitsPm permit;
    private final NotificationPm notification;
    private final SpecialMentionsPm specialMention;
    private final SensibleGoodsPm sensibleGoods;
    private final RepairAndRefinementPm repairAndRefinement;
    private final ConfirmationPm confirmation;
    private final NonCustomsLawPm nonCustomsLawPm;
    private final GoodsItemDetailPm goodsItemDetailPm;
    private final RefundPm refundPm;
    private final Disposables disposables = new Disposables();

    public GoodsItemPm(GoodsItem goodsItem) {
        this(goodsItem, false);
    }

    public GoodsItemPm(GoodsItem goodsItem, boolean enableLogic) {
        this.goodsItem = goodsItem;
        this.goodsData = new GoodsDataPm(goodsItem, enableLogic);
        this.producedDocument = new ProducedDocumentPm(goodsItem.getProducedDocuments());
        this.permit = new PermitsPm(goodsItem.getPermits());
        this.nonCustomsLawPm = new NonCustomsLawPm(goodsItem.getNonCustomLaws());
        this.goodsItemDetailPm = new GoodsItemDetailPm(goodsItem.getGoodsItemDetail());
        this.notification = new NotificationPm(goodsItem.getNotifications());
        this.specialMention = new SpecialMentionsPm(goodsItem.getSpecialMentions());
        this.sensibleGoods = new SensibleGoodsPm(goodsItem.getSensibleGoods());
        this.repairAndRefinement = new RepairAndRefinementPm(goodsItem.getRepairAndRefinement());
        this.confirmation = new ConfirmationPm(goodsItem.getConfirmation());
        this.refundPm = new RefundPm(goodsItem.getRefund());
    }

    public void add(IErrorListener errorListener) {
        this.disposables.add(this.goodsItem.addErrorListener(errorListener));
    }

    public NonCustomsLawPm getNonCustomsLawPm() {
        return this.nonCustomsLawPm;
    }

    public GoodsItemDetailPm getGoodsItemDetailPm() {
        return this.goodsItemDetailPm;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ProducedDocumentPm getProducedDocumentPm() {
        return this.producedDocument;
    }

    public NotificationPm getNotificationPm() {
        return this.notification;
    }

    public SpecialMentionsPm getSpecialMentionPm() {
        return this.specialMention;
    }

    public SensibleGoodsPm getSensibleGoodsPm() {
        return this.sensibleGoods;
    }

    public RepairAndRefinementPm getRepairAndRefinementPm() {
        return this.repairAndRefinement;
    }

    public ConfirmationPm getConfirmationPm() {
        return this.confirmation;
    }

    public GoodsDataPm getGoodsDataPm() {
        return this.goodsData;
    }

    public PermitsPm getPermitPm() {
        return this.permit;
    }

    public RefundPm getRefundPm() {
        return this.refundPm;
    }

    @Override
    public void saveChanges() {
    }
}

