/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Permit;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Permits;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.SelectionPm;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class PermitsPm
implements IPm,
IDisposable {
    private final TablePm<Permit> permits;
    private final SelectionPm permitObligation;
    private final Permits data;
    private final Disposables disposables = new Disposables();

    public PermitsPm(Permits permit) {
        this.data = permit;
        this.permitObligation = new SelectionPm(permit.getPermitObligation());
        this.permits = new TablePm<Permit>(permit.getPermitList(), Permit.class, Permit.tableConfig);
    }

    public TablePm<Permit> getPermits() {
        return this.permits;
    }

    public void add(IErrorListener errorListener) {
        this.disposables.add(this.data.addErrorListener(errorListener));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.data.getErrorInfo();
    }

    public SelectionPm getPermitObligation() {
        return this.permitObligation;
    }
}

