/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.IErrorListener;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.RecipeEntryALC;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.RecipeEntryLW;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Refund;
import ch.transsoft.edec.service.validate.ErrorInfo;
import ch.transsoft.edec.ui.pm.model.BooleanPm;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;

public class RefundPm
implements IPm,
IDisposable {
    private final TablePm<RecipeEntryALC> recipeEntriesAlc;
    private final TablePm<RecipeEntryLW> recipeEntriesLW;
    private final BooleanPm refundLW;
    private final BooleanPm refundVOC;
    private final BooleanPm refundALC;
    private final Disposables disposables = new Disposables();
    private final Refund data;

    public RefundPm(Refund refund) {
        this.data = refund;
        this.recipeEntriesAlc = new TablePm<RecipeEntryALC>(refund.getRecipeEntriesAlc(), RecipeEntryALC.class, RecipeEntryALC.tableConfig);
        this.recipeEntriesLW = new TablePm<RecipeEntryLW>(refund.getRecipeEntriesLW(), RecipeEntryLW.class, RecipeEntryLW.tableConfig);
        this.refundLW = new BooleanPm(refund.getRefundLW());
        this.refundVOC = new BooleanPm(refund.getRefundVOC());
        this.refundALC = new BooleanPm(refund.getRefundALC());
    }

    public TablePm<RecipeEntryALC> getRecipeEntriesAlc() {
        return this.recipeEntriesAlc;
    }

    public TablePm<RecipeEntryLW> getRecipeEntriesLW() {
        return this.recipeEntriesLW;
    }

    public BooleanPm getRefundLW() {
        return this.refundLW;
    }

    public BooleanPm getRefundVOC() {
        return this.refundVOC;
    }

    public BooleanPm getRefundALC() {
        return this.refundALC;
    }

    public void add(IErrorListener errorListener) {
        this.disposables.add(this.data.addErrorListener(errorListener));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.data.getErrorInfo();
    }
}

