/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.itemlist;

import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.ItemList;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.ui.gui.control.textfield.SimpleDocument;
import ch.transsoft.edec.ui.pm.model.TablePm;
import ch.transsoft.edec.ui.pm.sending.itemlist.action.CompactAction;
import ch.transsoft.edec.ui.pm.sending.itemlist.action.MoveDownAction;
import ch.transsoft.edec.ui.pm.sending.itemlist.action.MoveUpAction;
import ch.transsoft.edec.ui.pm.sending.itemlist.action.SaveInMasterdataAction;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.text.Document;
import net.miginfocom.swing.MigLayout;

public class TotalPm
implements IDisposable,
TablePm.ISelectionListener<GoodsItem> {
    private final Disposables disposables = new Disposables();
    private final ItemList itemList;
    private final SimpleDocument posCount;
    private final SimpleDocument netMass;
    private final SimpleDocument grossMass;
    private final SimpleDocument statisticalValueCHF;
    private final SimpleDocument statisticalValueDC;
    private final SimpleDocument statisticalValueDCLabel;
    private SaveInMasterdataAction saveInMasterDataAction;
    private CompactAction compactAction;
    private final MoveUpAction moveUpAction;
    private final MoveDownAction moveDownAction;
    private final IChangeListener posCountListener = (source, info) -> this.updateColisCount();
    private final IChangeListener netMassListener = (source, info) -> this.updateNetMass();
    private final IChangeListener grossMassListener = (source, info) -> this.updateGrossMass();
    private final IChangeListener statisticalValueListener = (source, info) -> {
        this.updateStatisticalValueCHF();
        this.updateStatisticalValueDC();
    };

    public TotalPm(ItemList itemList, Sending sending) {
        this.itemList = itemList;
        this.posCount = new SimpleDocument();
        this.netMass = new SimpleDocument();
        this.grossMass = new SimpleDocument();
        this.statisticalValueCHF = new SimpleDocument();
        this.statisticalValueDC = new SimpleDocument();
        this.statisticalValueDCLabel = new SimpleDocument();
        this.addPosCountListener();
        this.updateColisCount();
        this.addNetMassListener();
        this.updateNetMass();
        this.addGrossMassListener();
        this.updateGrossMass();
        this.addStatisticalValueListener();
        this.updateStatisticalValueCHF();
        this.updateStatisticalValueDC();
        this.moveDownAction = new MoveDownAction(itemList);
        this.moveUpAction = new MoveUpAction(itemList);
        if (sending != null) {
            this.saveInMasterDataAction = new SaveInMasterdataAction();
        }
        if (sending != null) {
            this.compactAction = new CompactAction(sending);
        }
    }

    private void addPosCountListener() {
        this.disposables.add(this.itemList.addFieldListener("quantity", this.posCountListener));
        this.disposables.add(this.itemList.addFieldListener("goodsItems", this.posCountListener));
    }

    private void addNetMassListener() {
        this.disposables.add(this.itemList.addFieldListener("netMass", this.netMassListener));
        this.disposables.add(this.itemList.addFieldListener("goodsItems", this.netMassListener));
    }

    private void addGrossMassListener() {
        this.disposables.add(this.itemList.addFieldListener("grossMass", this.grossMassListener));
        this.disposables.add(this.itemList.addFieldListener("goodsItems", this.grossMassListener));
    }

    private void addStatisticalValueListener() {
        this.disposables.add(this.itemList.addFieldListener("statisticalValue", this.statisticalValueListener));
        this.disposables.add(this.itemList.addFieldListener("currencyRate", this.statisticalValueListener));
        this.disposables.add(this.itemList.addFieldListener("goodsItems", this.statisticalValueListener));
    }

    private void updateColisCount() {
        this.posCount.setText(Integer.toString(this.itemList.getColisCount()));
    }

    private void updateNetMass() {
        this.netMass.setText(this.itemList.getTotalNetMass().toString());
    }

    private void updateGrossMass() {
        this.grossMass.setText(this.itemList.getTotalGrossMass().toString());
    }

    private void updateStatisticalValueCHF() {
        this.statisticalValueCHF.setText(this.itemList.getTotalStatisticalValueChf().toString());
    }

    private void updateStatisticalValueDC() {
        String currency = this.itemList.getBiggestForeignCurrency();
        if (currency == null) {
            this.statisticalValueDCLabel.setText("");
            this.statisticalValueDC.setText("");
        } else {
            this.statisticalValueDCLabel.setText(Services.format(1304, currency));
            this.statisticalValueDC.setText(this.itemList.getTotalStatisticalValueDC(currency).toString());
        }
    }

    public Document getPosCountModel() {
        return this.posCount;
    }

    public Document getNetMassModel() {
        return this.netMass;
    }

    public Document getGrossMassModel() {
        return this.grossMass;
    }

    public Document getStatisticalValueCHF() {
        return this.statisticalValueCHF;
    }

    public SimpleDocument getStatisticalValueDC() {
        return this.statisticalValueDC;
    }

    public SimpleDocument getStatisticalValueDCLabel() {
        return this.statisticalValueDCLabel;
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    @Override
    public void selectionChanged(GoodsItem current, boolean isEmptyLine, boolean sameItem) {
        this.moveDownAction.selectionChanged(current, isEmptyLine);
        this.moveUpAction.selectionChanged(current, isEmptyLine);
        if (this.compactAction != null) {
            this.compactAction.selectionChanged(current, isEmptyLine);
        }
        if (this.saveInMasterDataAction != null) {
            this.saveInMasterDataAction.selectionChanged(current, isEmptyLine);
        }
    }

    public Component getGoodsItemToolBar() {
        JToolBar result = new JToolBar();
        result.setFloatable(false);
        result.setBackground(Color.WHITE);
        result.setBorder(null);
        result.setLayout(new MigLayout("", "5[50!, fill][50!, fill]10[60!, fill]5[60!, fill]", "0[40!]0"));
        this.addAction(result, this.moveUpAction);
        this.addAction(result, this.moveDownAction);
        if (this.compactAction != null) {
            this.addAction(result, this.compactAction);
        }
        if (this.saveInMasterDataAction != null) {
            this.addAction(result, this.saveInMasterDataAction);
        }
        return result;
    }

    private void addAction(JToolBar toolbar, ActionBase action) {
        JButton button = toolbar.add(action);
        button.setText(action.getName());
        button.setFont(button.getFont().deriveFont(10.0f));
        button.setIconTextGap(0);
        button.setFocusable(false);
    }
}

