/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.sending.statusline;

import ch.transsoft.edec.model.infra.event.IChangeInfo;
import ch.transsoft.edec.model.infra.event.IChangeListener;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.disposable.Disposables;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;

public class SendingStatePm
implements IPm,
IDisposable,
IChangeListener {
    private final Sending sending;
    private final ListenerList<IChangeListener> listeners = new ListenerList();
    private final Disposables disposables = new Disposables();

    public SendingStatePm(Sending sending) {
        this.sending = sending;
        this.addModelListener();
    }

    private void addModelListener() {
        this.disposables.add(this.sending.addFieldListener("state", this));
    }

    @Override
    public void changed(INode<?> source, IChangeInfo info) {
        for (IChangeListener listener : this.listeners) {
            listener.changed(source, info);
        }
    }

    public void add(IChangeListener listener) {
        this.listeners.add(listener);
    }

    public Sending getSending() {
        return this.sending;
    }

    public void toggleInternalState() {
        this.sending.getState().toggleInternalState();
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

