/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.templates;

import ch.transsoft.edec.util.Check;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileNode {
    private File file;
    private final boolean isRoot;
    private List<FileNode> children;

    public FileNode(File file) {
        this(file, false);
    }

    public FileNode(File file, boolean isRoot) {
        Check.assertNotNull(file);
        this.isRoot = isRoot;
        this.file = file;
    }

    public FileNode getChild(int index) {
        if (this.children == null) {
            this.initChildren();
        }
        return this.children.get(index);
    }

    private void initChildren() {
        this.children = new ArrayList<FileNode>();
        ArrayList<String> childrenNames = new ArrayList<String>();
        String[] list = this.file.list();
        if (list == null) {
            return;
        }
        for (String name : list) {
            childrenNames.add(name);
        }
        Collections.sort(childrenNames);
        ArrayList<FileNode> files = new ArrayList<FileNode>();
        for (String name : childrenNames) {
            File currentFile = new File(this.file, name);
            if (currentFile.isDirectory()) {
                this.children.add(new FileNode(currentFile));
                continue;
            }
            files.add(new FileNode(currentFile));
        }
        this.children.addAll(files);
    }

    public String toString() {
        return this.isRoot ? this.file.toString() : this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        FileNode node = (FileNode)obj;
        return this.file.equals(node.file);
    }

    public int getIndexOfChild(Object child) {
        if (this.children == null) {
            this.initChildren();
        }
        return this.children.indexOf(child);
    }

    public int getChildCount() {
        if (this.children == null) {
            this.initChildren();
        }
        return this.children.size();
    }
}

