/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.ui.pm.templates;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.ui.pm.templates.FileNode;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.io.File;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TemplateModel
implements TreeModel {
    private FileNode root;
    private final ListenerList<TreeModelListener> listeners = new ListenerList();

    public TemplateModel() {
        File templateDir = Services.get(IConfigService.class).getTemplateDir(true);
        this.root = new FileNode(templateDir, true);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l2) {
        this.listeners.add(l2);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((FileNode)parent).getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((FileNode)parent).getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((FileNode)parent).getIndexOfChild(child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    public void refresh() {
        File rootFile = Services.get(IConfigService.class).getTemplateDir(true);
        this.root = new FileNode(rootFile, true);
        this.notifyRefresh();
    }

    private void notifyRefresh() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.root});
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    @Override
    public boolean isLeaf(Object node) {
        File file = ((FileNode)node).getFile();
        return file.isFile();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l2) {
        this.listeners.remove(l2);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw Check.unsupportedOperation();
    }
}

