/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.util.Base64;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.DateUtil;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class CertificateUtil {
    public static boolean isPasswordValid(String cert, String password) {
        KeyStore clientKeyStore = null;
        ByteArrayInputStream certStream = null;
        try {
            clientKeyStore = KeyStore.getInstance("PKCS12");
            certStream = new ByteArrayInputStream(Base64.decode(cert));
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
        try {
            clientKeyStore.load(certStream, password.toCharArray());
        }
        catch (Exception e3) {
            return false;
        }
        return true;
    }

    public static String getCertificateEndDate(String cert, String password) {
        try {
            KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
            ByteArrayInputStream certStream = new ByteArrayInputStream(Base64.decode(cert));
            clientKeyStore.load(certStream, password.toCharArray());
            Enumeration<String> iter = clientKeyStore.aliases();
            if (!iter.hasMoreElements()) {
                return Services.getText(4159);
            }
            X509Certificate certificate = (X509Certificate)clientKeyStore.getCertificate(iter.nextElement());
            return DateUtil.formatDate(certificate.getNotAfter());
        }
        catch (Exception e2) {
            return Services.getText(4159);
        }
    }
}

