/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.util.FatalException;
import javax.swing.SwingUtilities;

public class Check {
    public static RuntimeException fatal(Throwable t) {
        throw new FatalException(t);
    }

    public static RuntimeException fatal(Throwable t, Object ... message) {
        throw new FatalException(Check.createMessage(message), t);
    }

    public static RuntimeException fatal(Object ... message) {
        throw new FatalException(Check.createMessage(message));
    }

    public static RuntimeException fail(Throwable t) {
        throw new RuntimeException(t);
    }

    public static RuntimeException fail(Throwable t, Object ... message) {
        throw new RuntimeException(Check.createMessage(message), t);
    }

    public static RuntimeException fail(Object ... message) {
        throw new RuntimeException(Check.createMessage(message));
    }

    public static void assertTrue(boolean condition, Object ... messages) {
        if (!condition) {
            Check.fail(Check.createMessage(messages));
        }
    }

    public static void assertFalse(boolean condition, Object ... messages) {
        if (condition) {
            Check.fail(Check.createMessage(messages));
        }
    }

    public static void assertNull(Object obj) {
        if (obj != null) {
            Check.fail("null expected but was " + obj);
        }
    }

    public static void assertNotNull(Object obj) {
        Check.assertNotNull(obj, "object is null");
    }

    public static void assertNotNull(Object obj, Object ... messages) {
        if (obj == null) {
            Check.fail(Check.createMessage(messages));
        }
    }

    public static String createMessage(Object[] message) {
        if (message == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < message.length; ++i2) {
            if (i2 != 0) {
                result.append(" ");
            }
            result.append(message[i2]);
        }
        return result.toString();
    }

    public static void equals(Object expected, Object actual) {
        if (!expected.equals(actual)) {
            Check.fail(expected + " != " + actual);
        }
    }

    public static RuntimeException illegalState() {
        throw new IllegalStateException();
    }

    public static void assertEquals(Object o1, Object o2) {
        if (!o1.equals(o2)) {
            Check.fail(o1, "expected but was", o2);
        }
    }

    public static void assertSame(Object o1, Object o2) {
        if (o1 != o2) {
            Check.fail(o1, " != ", o2);
        }
    }

    public static void assertNotSame(Object o1, Object o2) {
        if (o1 == o2) {
            Check.fail(o1, " == ", o2);
        }
    }

    public static void checkEDT() {
        Check.assertTrue(SwingUtilities.isEventDispatchThread(), "not inside EDT but ", Thread.currentThread().getName());
    }

    public static RuntimeException unsupportedOperation() {
        return Check.fail("unsupported operation");
    }
}

