/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.util.Check;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateUtil {
    private static Date NOW = new Date();
    private static String dateFormat = "dd.MM.yyyy";
    private static String ezvDateFormat = "yyyy-MM-dd";
    private static String ezvTimeFormat = "hh:mm:ss";
    private static String longFormat = "dd.MM.yyyy HH:mm:ss:SSS";
    private static Pattern edecDatePattern = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d");

    public static TimeZone getDefaultTimeZone() {
        return TimeZone.getTimeZone("Europe/Zurich");
    }

    public static DateFormat getDateFormat() {
        return DateUtil.getSimpleDateFormat(dateFormat);
    }

    private static DateFormat getEzvDateFormat() {
        return DateUtil.getSimpleDateFormat(ezvDateFormat);
    }

    private static DateFormat getEzvTimeFormat() {
        return DateUtil.getSimpleDateFormat(ezvTimeFormat);
    }

    private static DateFormat getLongFormat() {
        return DateUtil.getSimpleDateFormat(longFormat);
    }

    public static DateFormat getSimpleDateFormat(String format) {
        SimpleDateFormat result = new SimpleDateFormat(format);
        result.setTimeZone(DateUtil.getDefaultTimeZone());
        return result;
    }

    public static List<DateRange> getRanges(Date start, Date end, int interval) {
        Date currentEnd;
        ArrayList<DateRange> result = new ArrayList<DateRange>();
        if (start.after(end)) {
            return result;
        }
        Date currentStart = start;
        do {
            if ((currentEnd = DateUtil.add(currentStart, interval)).after(end)) {
                result.add(new DateRange(currentStart, end));
                return result;
            }
            result.add(new DateRange(currentStart, currentEnd));
        } while (!(currentStart = DateUtil.add(currentEnd, 1)).after(end));
        return result;
    }

    public static String getCurrentDateAsStr() {
        return DateUtil.formatDate(new Date());
    }

    public static synchronized String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtil.getDateFormat().format(date);
    }

    public static Date add(Date first, int days) {
        return new Date(first.getTime() + (long)days * 86400000L);
    }

    public static int getAge(Date date) {
        return DateUtil.getAge(date, new Date());
    }

    public static int getAge(Date date, Date now) {
        return (int)((now.getTime() - date.getTime()) / 86400000L);
    }

    public static boolean isValid(String fromStr, String toStr) {
        return DateUtil.isValid(fromStr, toStr, NOW);
    }

    public static synchronized String formatEzvDate(Date date) {
        return DateUtil.getEzvDateFormat().format(date);
    }

    public static int getCurrentYear() {
        return DateUtil.getYear(new Date());
    }

    public static int getYear(Date date) {
        return Integer.parseInt(DateUtil.getSimpleDateFormat("yyyy").format(date));
    }

    public static List<Integer> getYearsBackFrom(Date start, int years) {
        return DateUtil.getYearsBackFrom(DateUtil.getYear(start), years);
    }

    public static List<Integer> getYearsBackFrom(int startYear, int years) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i2 = 0; i2 < years; ++i2) {
            result.add(startYear - i2);
        }
        return result;
    }

    public static boolean isValid(String fromStr, String toStr, Date now) {
        Date from = DateUtil.getDate(fromStr);
        Date to = DateUtil.getDate(toStr);
        return from.before(now) && to.after(now);
    }

    public static synchronized Date getDate(String string) {
        try {
            return DateUtil.getEzvDateFormat().parse(string);
        }
        catch (ParseException e2) {
            throw Check.fail(e2);
        }
    }

    public static synchronized Date getDate(String date, String time) {
        try {
            Date result = DateUtil.getEzvDateFormat().parse(date);
            if (time == null) {
                return result;
            }
            Calendar gregDate = DateUtil.createGregorianCalendar();
            gregDate.setTime(result);
            Calendar gregTime = GregorianCalendar.getInstance();
            gregTime.setTime(DateUtil.getEzvTimeFormat().parse(time));
            gregDate.set(11, gregTime.get(11));
            gregDate.set(12, gregTime.get(12));
            gregDate.set(13, gregTime.get(13));
            return gregDate.getTime();
        }
        catch (ParseException e2) {
            throw Check.fail(e2);
        }
    }

    public static Calendar createGregorianCalendar() {
        Calendar gregDate = GregorianCalendar.getInstance();
        gregDate.setTimeZone(DateUtil.getDefaultTimeZone());
        return gregDate;
    }

    public static synchronized Date parseLongDate(String string) {
        try {
            return DateUtil.getLongFormat().parse(string);
        }
        catch (ParseException e2) {
            throw Check.fail(e2);
        }
    }

    public static Date parseDate(String date) {
        try {
            return DateUtil.getDateFormat().parse(date);
        }
        catch (ParseException e2) {
            throw Check.fail(e2);
        }
    }

    public static Date getNormalizedDate(Date date) {
        try {
            return DateUtil.getDateFormat().parse(DateUtil.getDateFormat().format(date));
        }
        catch (ParseException e2) {
            throw Check.fail(e2);
        }
    }

    public static String createId() {
        return Long.toString(System.currentTimeMillis());
    }

    public static Date getTimestamp(XMLGregorianCalendar date, XMLGregorianCalendar time) {
        GregorianCalendar result = date.toGregorianCalendar();
        result.setTimeZone(DateUtil.getDefaultTimeZone());
        GregorianCalendar t = time.toGregorianCalendar();
        result.set(11, t.get(11));
        result.set(12, t.get(12));
        result.set(13, t.get(13));
        return result.getTime();
    }

    public static boolean isEdecDate(String str) {
        return edecDatePattern.matcher(str).matches();
    }

    public static Date toDate(EdecDateNode node) {
        Check.assertTrue(node.isInitialized(), "EdecDate not initialized");
        Calendar cal = DateUtil.createGregorianCalendar();
        cal.set(node.getYear(), node.getMonth() - 1, node.getDay(), 0, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static String toEdecDateString(XMLGregorianCalendar cal) {
        return DateUtil.asEdecDate(cal.getYear(), cal.getMonth(), cal.getDay());
    }

    public static Date getEndOfDay(Date date) {
        Calendar cal = DateUtil.createGregorianCalendar();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getDateOffset(Date date, int offsetDays) {
        Calendar cal = DateUtil.createGregorianCalendar();
        cal.setTime(date);
        cal.add(5, offsetDays);
        return cal.getTime();
    }

    public static String asEdecDate(int year, int month, int day) {
        return DateUtil.fixIntSize(year, 4) + "-" + DateUtil.fixIntSize(month, 2) + "-" + DateUtil.fixIntSize(day, 2);
    }

    private static String fixIntSize(int number, int digits) {
        Object result = Integer.toString(number);
        Check.assertTrue(((String)result).length() <= digits, number + "has more than " + digits + " digits");
        while (((String)result).length() < digits) {
            result = "0" + (String)result;
        }
        return result;
    }

    public static XMLGregorianCalendar toXmlGregorianCalendar(Date date) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(DateUtil.getEzvDateFormat().format(date));
        }
        catch (DatatypeConfigurationException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static class DateRange {
        public Date start;
        public Date end;

        public DateRange(Date start, Date end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return DateUtil.getLongFormat().format(this.start) + " - " + DateUtil.getLongFormat().format(this.end);
        }
    }
}

