/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import java.net.ConnectException;
import java.util.List;
import org.openapitools.client.ApiException;

public class ErrorUtil {
    public static void handleConnectionError(ApiException e2) {
        if (e2.getCause() instanceof ConnectException) {
            ErrorUtil.log(e2.getCause(), Services.getText(622) + "\n" + Services.getText(623));
        } else {
            ErrorUtil.log(e2, Services.getText(622));
        }
    }

    public static void log(Throwable cause, String string) {
        Services.get(ILoggingService.class).logAndReport(cause, string);
    }

    public static String getErrorString(List<String> errorList) {
        if (errorList.isEmpty()) {
            return "No Rule-error available";
        }
        StringBuilder errorText = new StringBuilder();
        for (String error : errorList) {
            errorText.append(error);
            errorText.append("\n");
        }
        return errorText.toString();
    }

    public static void showErrors(String title, List<String> errorList) {
        DialogUtil.showErrorDialog(title, ErrorUtil.getErrorString(errorList));
    }
}

