/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import java.awt.Component;
import java.io.File;
import java.nio.file.InvalidPathException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class FileChooserUtil {
    public static File[] chooseFiles(File currentDirectory, String title, String filename, String approveButtonText, String fileExtension) {
        SaveJFileChooser dialog = new SaveJFileChooser();
        dialog.setCurrentDirectory(currentDirectory);
        if (filename != null) {
            dialog.setSelectedFile(new File(filename));
        }
        if (approveButtonText != null) {
            dialog.setApproveButtonText(approveButtonText);
        }
        dialog.setDialogTitle(title);
        dialog.setMultiSelectionEnabled(true);
        dialog.setFileSelectionMode(0);
        if (fileExtension != null) {
            String description = fileExtension + "-" + Services.getText(646);
            dialog.setFileFilter(new FileNameExtensionFilter(description, fileExtension.toLowerCase()));
        }
        ((JFileChooser)dialog).showOpenDialog(Services.get(IGuiService.class).getMainFrame());
        return dialog.getSelectedFiles();
    }

    public static File[] chooseFiles(File currentDirectory, String title, String filename, String approveButtonText) {
        return FileChooserUtil.chooseFiles(currentDirectory, title, filename, approveButtonText, null);
    }

    public static File chooseFolder(File currentDirectory, String title, String okButtonText) {
        SaveJFileChooser dialog = new SaveJFileChooser();
        dialog.setApproveButtonText(okButtonText);
        dialog.setCurrentDirectory(currentDirectory);
        dialog.setDialogTitle(title);
        dialog.setMultiSelectionEnabled(false);
        dialog.setFileSelectionMode(1);
        int result = ((JFileChooser)dialog).showOpenDialog(Services.get(IGuiService.class).getMainFrame());
        if (result == 1) {
            return null;
        }
        return dialog.getSelectedFile();
    }

    public static File[] chooseDirs(File currentDirectory, String title) {
        SaveJFileChooser dialog = new SaveJFileChooser();
        dialog.setCurrentDirectory(currentDirectory);
        dialog.setDialogTitle(title);
        dialog.setMultiSelectionEnabled(true);
        dialog.setFileSelectionMode(1);
        int result = ((JFileChooser)dialog).showOpenDialog(Services.get(IGuiService.class).getMainFrame());
        if (result == 1) {
            return new File[0];
        }
        return dialog.getSelectedFiles();
    }

    private static class SaveJFileChooser
    extends JFileChooser {
        private SaveJFileChooser() {
        }

        @Override
        public int showOpenDialog(Component parent) {
            Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler((t, e2) -> {
                if (e2 instanceof InvalidPathException) {
                    DialogUtil.showWarningDialog("Warning", e2.getLocalizedMessage());
                } else {
                    defaultUncaughtExceptionHandler.uncaughtException(t, e2);
                }
            });
            int result = super.showOpenDialog(parent);
            Thread.setDefaultUncaughtExceptionHandler(defaultUncaughtExceptionHandler);
            return result;
        }
    }
}

