/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.ui.gui.control.RadioButton;
import ch.transsoft.edec.util.disposable.Disposables;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class RadioButtonUtil {
    public static JRadioButton createRadioButton(ButtonGroup group, String label) {
        RadioButton result = new RadioButton(label, true);
        group.add(result);
        return result;
    }

    public static void connectRadio(Disposables disposables, ButtonGroup radioGroup, IntegralNode node, JRadioButton ... radioButtons) {
        List<JRadioButton> radios = Arrays.asList(radioButtons);
        if (node.isInitialized()) {
            radios.get(node.getIntValue()).setSelected(true);
        }
        disposables.add(node.addChangeListener((source, info) -> {
            if (!node.isInitialized()) {
                if (radioGroup != null) {
                    radioGroup.clearSelection();
                }
                return;
            }
            radioButtons[node.getIntValue()].setSelected(true);
        }));
        for (JRadioButton radio : radios) {
            radio.addActionListener(e2 -> {
                if (radioGroup != null && node.isInitialized() && node.getValue() == (long)radios.indexOf(radio)) {
                    radioGroup.clearSelection();
                    node.setValue(null);
                    return;
                }
                node.setValue(Long.valueOf(radios.indexOf(radio)));
            });
        }
    }
}

