/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.ui.pm.model.IPm;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.TextUtil;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    public static boolean isPersistable(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        field.setAccessible(true);
        return true;
    }

    public static void recursiveDispose(IPm root) {
        try {
            ReflectionUtil.internalDispose(root);
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    private static void internalDispose(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            return;
        }
        if (obj instanceof IDisposable) {
            ((IDisposable)obj).dispose();
        }
        if (!(obj instanceof IPm)) {
            return;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            ReflectionUtil.internalDispose(field.get(obj));
        }
    }

    public static void handleChildren(ModelNode<?> parent, NodeHandler handler) {
        for (Field field : parent.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field)) continue;
            try {
                handler.handle((INode)field.get(parent));
            }
            catch (Exception e2) {
                Check.fail(e2);
            }
        }
    }

    public static INode<?> getField(ModelNode<?> obj, String fieldName) {
        String methodName = TextUtil.toGetter(fieldName);
        try {
            Method method = obj.getClass().getMethod(methodName, ModelNode.EMPTY_CLASS_ARRAY);
            return (INode)method.invoke(obj, ModelNode.EMPTY_OBJECT_ARRAY);
        }
        catch (Exception e2) {
            throw Check.fail(e2, "method", methodName, "not found on ", obj.getClass().getName());
        }
    }

    public static <T> Class<T> getTypedClassBestEffort(Class<?> aClass) {
        return aClass;
    }

    public static <T> Class<T> getTypedClass(T instance) {
        return instance.getClass();
    }

    public static <T extends NodeBase<T>> Class<T> getTypedFieldTypeBestEffort(Field field) {
        return field.getType();
    }

    public static interface NodeHandler {
        public void handle(INode<?> var1);
    }
}

