/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

import ch.transsoft.edec.model.config.conf.license.CertificateInfo;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.CertificateUtil;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;

public class SystemUtil {
    public static String getDebugVersionString() {
        String expoVit = Services.get(IConfigService.class).getVersionString();
        String user = Services.get(IConfigService.class).getUserName();
        String os = SystemUtil.getOsNameAndVersion();
        String system = SystemUtil.getRuntimeVersion();
        String launcher = SystemUtil.getLauncherVersion();
        String deployment = SystemUtil.getDeployString();
        String jvmArgs = SystemUtil.getJVMArguments();
        return "ExpoVit: " + expoVit + ", user: " + user + ", OS: " + os + ", runtime: " + system + ", deployment: " + deployment + ", launcher: " + launcher + ", jvmArgs: " + jvmArgs;
    }

    private static String getJVMArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        return arguments.toString();
    }

    public static String getOsNameAndVersion() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        return name + " (" + version + ")";
    }

    public static String getLauncherVersion() {
        return System.getProperty("launcher.version");
    }

    public static String getRuntimeVersion() {
        return System.getProperty("java.runtime.version");
    }

    public static boolean isLaunchedByLauncher() {
        return SystemUtil.getLauncherVersion() != null;
    }

    public static String getDeployString() {
        return SystemUtil.isLaunchedByLauncher() ? "" : "jar";
    }

    public static boolean isOsWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static String getCertificateEndDate() {
        CertificateInfo certInfo = Services.get(IConfigService.class).getLicenseInfo().getCertificate();
        if (!certInfo.isReady()) {
            return Services.getText(4159);
        }
        String data = certInfo.getCertificateData().getValue();
        String pw = certInfo.getCertificatePassword().getValue();
        return CertificateUtil.getCertificateEndDate(data, pw);
    }

    public static String getMemoryInfo() {
        return Runtime.getRuntime().totalMemory() / 1000000L + " / " + Runtime.getRuntime().maxMemory() / 1000000L + "MB";
    }

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home"));
    }
}

