/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util;

public final class Version {
    private final int major;
    private final int minor;
    private final int patch;
    private final int buildNumber;

    public static boolean isSmaller(String first, String second) {
        return new Version(first).isSmaller(new Version(second));
    }

    public static boolean majorMinorEquals(String first, String second) {
        return new Version(first).majorMinorEquals(new Version(second));
    }

    public Version(String version) {
        String[] segStrs = version.split("\\.");
        int n = segStrs.length > 0 ? (segStrs[0].isEmpty() ? 0 : Integer.parseInt(segStrs[0])) : (this.major = 0);
        int n2 = segStrs.length > 1 ? (segStrs[1].isEmpty() ? 0 : Integer.parseInt(segStrs[1])) : (this.minor = 0);
        if (segStrs.length > 2) {
            if (segStrs[2].contains("-")) {
                String[] patchBuildNumber = segStrs[2].split("-");
                this.patch = Integer.parseInt(patchBuildNumber[0]);
                this.buildNumber = Integer.parseInt(patchBuildNumber[1]);
            } else {
                this.patch = Integer.parseInt(segStrs[2]);
                this.buildNumber = 0;
            }
        } else {
            this.patch = 0;
            this.buildNumber = 0;
        }
    }

    private boolean majorMinorEquals(Version other) {
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public boolean isSmaller(Version other) {
        if (this.major != other.major) {
            return this.major < other.major;
        }
        if (this.minor != other.minor) {
            return this.minor < other.minor;
        }
        if (this.patch != other.patch) {
            return this.patch < other.patch;
        }
        if (this.buildNumber == other.buildNumber) {
            return false;
        }
        if (this.buildNumber == 0) {
            return false;
        }
        if (other.buildNumber == 0) {
            return true;
        }
        return this.buildNumber < other.buildNumber;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (String)(this.buildNumber > 0 ? "-" + this.buildNumber : "");
    }
}

