/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util.disposable;

import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.disposable.IDisposable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ListenerList<T>
implements Iterable<T> {
    private final List<T> fListeners = new ArrayList<T>();

    public IDisposable add(T listener) {
        this.fListeners.add(listener);
        return new RemoveEntry<T>(this.fListeners, listener);
    }

    private List<T> getListeners() {
        return new ArrayList<T>(this.fListeners);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getListeners().iterator();
    }

    public void reset() {
        this.fListeners.clear();
    }

    public void remove(T listener) {
        Check.assertTrue(this.fListeners.remove(listener), "listener not in the list: " + listener);
    }

    public boolean isEmpty() {
        return this.fListeners.isEmpty();
    }

    public int size() {
        return this.fListeners.size();
    }

    public String toString() {
        return this.fListeners.toString();
    }

    private static class RemoveEntry<T>
    implements IDisposable {
        private T listener;
        private List<T> list;

        public RemoveEntry(List<T> list, T listener) {
            this.listener = listener;
            this.list = list;
        }

        @Override
        public void dispose() {
            if (this.list == null) {
                return;
            }
            this.list.remove(this.listener);
            this.list = null;
            this.listener = null;
        }
    }
}

