/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util.pdf;

import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.pdf.IPDFWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class DefaultPDFWriter
implements IPDFWriter {
    private Document document;
    private ByteArrayOutputStream baos;
    private BufferedOutputStream bos;
    private Rectangle pageSize;
    private PdfWriter writer;

    public DefaultPDFWriter() {
        this(PageSize.A4);
    }

    public DefaultPDFWriter(Rectangle pageSize) {
        this.pageSize = pageSize;
        try {
            this.document = new Document();
            PipedInputStream pis = new PipedInputStream();
            PipedOutputStream pos = new PipedOutputStream();
            pos.connect(pis);
            this.baos = new ByteArrayOutputStream();
            this.bos = new BufferedOutputStream(this.baos, 512);
            this.writer = PdfWriter.getInstance(this.document, this.bos);
            this.document.open();
        }
        catch (DocumentException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    @Override
    public Graphics addPage() {
        this.document.newPage();
        PdfContentByte cb = this.writer.getDirectContent();
        Graphics2D g2 = cb.createGraphics(this.pageSize.getWidth(), this.pageSize.getHeight());
        return g2;
    }

    @Override
    public byte[] complete() {
        this.document.close();
        FileUtil.close(this.bos);
        return this.baos.toByteArray();
    }
}

