/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util.ui.disclosure;

import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import ch.transsoft.edec.util.ui.ResponsiveItem;
import ch.transsoft.edec.util.ui.disclosure.ResponsiveDisclosureListener;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.nio.file.Path;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXRadioGroup;
import org.jdesktop.swingx.VerticalLayout;

public final class ResponsiveDisclosure
extends JComponent {
    private JXRadioGroup<ResponsiveItem> buttonPanel;
    private JPanel itemPanel;
    private final ListenerList<ResponsiveDisclosureListener> listeners = new ListenerList();

    public ResponsiveDisclosure() {
        this.initComponents();
    }

    public void addItem(ResponsiveItem item) {
        this.buttonPanel.add(item);
        int index = this.buttonPanel.getChildButtonCount() - 1;
        AbstractButton button = this.buttonPanel.getChildButton(index);
        this.configureButtonForItem(button, item);
        JPanel panel = this.createItemPanel();
        item.createContent(panel);
        this.itemPanel.add((Component)panel, item.getLabel());
        if (index == 0) {
            this.buttonPanel.setSelectedValue(item);
        }
    }

    public IDisposable addListener(ResponsiveDisclosureListener listener) {
        return this.listeners.add(listener);
    }

    public ResponsiveItem getSelectedItem() {
        return this.buttonPanel.getSelectedValue();
    }

    public void setSelectedItem(ResponsiveItem item) {
        this.buttonPanel.setSelectedValue(item);
        this.changeSelectedItem();
    }

    private void notifyListeners(ResponsiveItem selectedValue) {
        for (ResponsiveDisclosureListener listener : this.listeners) {
            listener.selectionChanged(selectedValue);
        }
    }

    private void changeSelectedItem() {
        ResponsiveItem selectedValue = this.buttonPanel.getSelectedValue();
        this.getItemStack().show(this.itemPanel, selectedValue.getLabel());
        this.notifyListeners(selectedValue);
    }

    private void configureButtonForItem(AbstractButton button, ResponsiveItem item) {
        button.setText(item.getLabel());
        button.setIconTextGap(3);
        button.setOpaque(false);
        Path path = item.getIconPath();
        if (path != null) {
            button.setIcon(this.loadIcon(path));
        }
    }

    private JPanel createItemPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new VerticalLayout(0));
        this.buttonPanel = new JXRadioGroup();
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayoutAxis(1);
        this.wireButtonPanelListener();
        mainPanel.add(this.buttonPanel);
        this.itemPanel = new JPanel();
        this.itemPanel.setOpaque(false);
        this.itemPanel.setLayout(new CardLayout());
        mainPanel.add(this.itemPanel);
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add(mainPanel);
    }

    private CardLayout getItemStack() {
        return (CardLayout)this.itemPanel.getLayout();
    }

    private void initComponents() {
        this.createMainPanel();
    }

    private Icon loadIcon(Path path) {
        return IconLoader.getIcon(path.toString());
    }

    private void wireButtonPanelListener() {
        this.buttonPanel.addActionListener(e2 -> {
            if (e2 == null) {
                return;
            }
            this.changeSelectedItem();
        });
    }
}

