/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.util.ui.enablement;

import ch.transsoft.edec.ui.img.IconLoader;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import ch.transsoft.edec.util.ui.ResponsiveItem;
import ch.transsoft.edec.util.ui.enablement.ResponsiveEnablementListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.nio.file.Path;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.VerticalLayout;

public final class ResponsiveEnablement
extends JComponent {
    private JCheckBox checkBox;
    private ResponsiveItem responsiveItem;
    private JPanel itemPanel;
    private final ListenerList<ResponsiveEnablementListener> listeners = new ListenerList();

    public ResponsiveEnablement(ResponsiveItem item, boolean enablement) {
        this.createMainPanel();
        this.setItem(item);
        this.setEnabledState(enablement);
    }

    private void setItem(ResponsiveItem item) {
        this.responsiveItem = item;
        this.configureCheckbox(item);
        JPanel panel = this.createItemPanel();
        item.createContent(panel);
        this.itemPanel.add(panel);
    }

    public IDisposable addListener(ResponsiveEnablementListener listener) {
        return this.listeners.add(listener);
    }

    public ResponsiveItem getItem() {
        return this.responsiveItem;
    }

    public boolean getState() {
        return this.checkBox.isSelected();
    }

    public void setEnabledState(boolean enabledState) {
        this.checkBox.setSelected(enabledState);
        this.changeEnablement();
    }

    private void notifyListeners() {
        for (ResponsiveEnablementListener listener : this.listeners) {
            listener.selectionChanged(this.getState());
        }
    }

    private void changeEnablement() {
        this.setItemPanelEnabled(this.checkBox.isSelected());
        this.notifyListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
        this.setItemPanelEnabled(enabled && this.checkBox.isSelected());
    }

    private void setItemPanelEnabled(boolean enabled) {
        this.itemPanel.setEnabled(enabled);
        this.setRecursiveEnabled(this.itemPanel, enabled);
    }

    private void setRecursiveEnabled(Container container, boolean enabled) {
        Arrays.stream(container.getComponents()).forEach(current -> {
            current.setEnabled(enabled);
            if (current instanceof ResponsiveEnablement || !(current instanceof Container)) {
                return;
            }
            this.setRecursiveEnabled((Container)current, enabled);
        });
    }

    private void configureCheckbox(ResponsiveItem item) {
        this.checkBox.setText(item.getLabel());
        this.checkBox.setIconTextGap(3);
        this.checkBox.setOpaque(false);
        Path path = item.getIconPath();
        if (path != null) {
            this.checkBox.setIcon(this.loadIcon(path));
        }
    }

    private JPanel createItemPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new MigLayout("fill", "[fill]", "[][]"));
        this.checkBox = new JCheckBox();
        this.checkBox.setOpaque(false);
        this.wireCheckboxListener();
        mainPanel.add((Component)this.checkBox, "wrap");
        this.itemPanel = new JPanel();
        this.itemPanel.setOpaque(false);
        this.itemPanel.setLayout(new VerticalLayout(0));
        mainPanel.add(this.itemPanel);
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add(mainPanel);
    }

    private Icon loadIcon(Path path) {
        return IconLoader.getIcon(path.toString());
    }

    private void wireCheckboxListener() {
        this.checkBox.addActionListener(e2 -> {
            if (e2 == null) {
                return;
            }
            this.changeEnablement();
        });
    }
}

