/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.writer;

import java.util.Enumeration;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class ContentHandlerAdaptor
implements DocumentHandler {
    private final NamespaceSupport nsSupport = new NamespaceSupport();
    private final ContentHandler contentHandler;
    private final AttributeListAdapter attAdapter = new AttributeListAdapter();
    private final AttributesImpl atts = new AttributesImpl();
    private final boolean namespaces = true;
    private final boolean prefixes = false;
    private final String[] nameParts = new String[3];

    public ContentHandlerAdaptor(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void startElement(String qName, AttributeList qAtts) throws SAXException {
        String attQName;
        int i2;
        this.nsSupport.pushContext();
        boolean seenDecl = false;
        this.atts.clear();
        int length = qAtts.getLength();
        for (i2 = 0; i2 < length; ++i2) {
            attQName = qAtts.getName(i2);
            String type = qAtts.getType(i2);
            String value = qAtts.getValue(i2);
            if (attQName.startsWith("xmlns")) {
                int n = attQName.indexOf(58);
                String prefix = n == -1 ? "" : attQName.substring(n + 1);
                if (!this.nsSupport.declarePrefix(prefix, value)) {
                    this.reportError("Illegal Namespace prefix: " + prefix);
                }
                if (this.contentHandler != null) {
                    this.contentHandler.startPrefixMapping(prefix, value);
                }
                seenDecl = true;
                continue;
            }
            String[] attName = this.processName(attQName, true);
            this.atts.addAttribute(attName[0], attName[1], attName[2], type, value);
        }
        if (seenDecl) {
            length = this.atts.getLength();
            for (i2 = 0; i2 < length; ++i2) {
                attQName = this.atts.getQName(i2);
                if (attQName.startsWith("xmlns")) continue;
                String[] attName = this.processName(attQName, true);
                this.atts.setURI(i2, attName[0]);
                this.atts.setLocalName(i2, attName[1]);
            }
        }
        if (this.contentHandler != null) {
            String[] name = this.processName(qName, false);
            this.contentHandler.startElement(name[0], name[1], name[2], this.atts);
        }
    }

    public void endElement(String qName) throws SAXException {
        String[] names = this.processName(qName, false);
        if (this.contentHandler != null) {
            this.contentHandler.endElement(names[0], names[1], names[2]);
            Enumeration prefixes = this.nsSupport.getDeclaredPrefixes();
            while (prefixes.hasMoreElements()) {
                String prefix = (String)prefixes.nextElement();
                this.contentHandler.endPrefixMapping(prefix);
            }
        }
        this.nsSupport.popContext();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    private String[] processName(String qName, boolean isAttribute) throws SAXException {
        String[] parts = this.nsSupport.processName(qName, this.nameParts, isAttribute);
        if (parts == null) {
            parts = new String[3];
            parts[2] = qName.intern();
            this.reportError("Undeclared prefix: " + qName);
        }
        return parts;
    }

    void reportError(String message) throws SAXException {
        throw new SAXParseException(message, null, null, -1, -1);
    }

    final class AttributeListAdapter
    implements Attributes {
        private AttributeList qAtts;

        AttributeListAdapter() {
        }

        void setAttributeList(AttributeList qAtts) {
            this.qAtts = qAtts;
        }

        public int getLength() {
            return this.qAtts.getLength();
        }

        public String getURI(int i2) {
            return "";
        }

        public String getLocalName(int i2) {
            return "";
        }

        public String getQName(int i2) {
            return this.qAtts.getName(i2).intern();
        }

        public String getType(int i2) {
            return this.qAtts.getType(i2).intern();
        }

        public String getValue(int i2) {
            return this.qAtts.getValue(i2);
        }

        public int getIndex(String uri, String localName) {
            return -1;
        }

        public int getIndex(String qName) {
            int max = ContentHandlerAdaptor.this.atts.getLength();
            for (int i2 = 0; i2 < max; ++i2) {
                if (!this.qAtts.getName(i2).equals(qName)) continue;
                return i2;
            }
            return -1;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return this.qAtts.getType(qName).intern();
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            return this.qAtts.getValue(qName);
        }
    }
}

