/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import java.util.ArrayList;

public class FontSelector {
    protected ArrayList fonts = new ArrayList();

    public void addFont(Font font) {
        if (font.getBaseFont() != null) {
            this.fonts.add(font);
            return;
        }
        BaseFont baseFont = font.getCalculatedBaseFont(true);
        Font font2 = new Font(baseFont, font.getSize(), font.getCalculatedStyle(), font.getColor());
        this.fonts.add(font2);
    }

    public Phrase process(String string) {
        int n = this.fonts.size();
        if (n == 0) {
            throw new IndexOutOfBoundsException("No font is defined.");
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        Font font = null;
        int n3 = -1;
        Phrase phrase = new Phrase();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            char c2 = cArray[i2];
            if (c2 == '\n' || c2 == '\r') {
                stringBuffer.append(c2);
                continue;
            }
            if (Utilities.isSurrogatePair(cArray, i2)) {
                n4 = Utilities.convertToUtf32(cArray, i2);
                for (int i3 = 0; i3 < n; ++i3) {
                    font = (Font)this.fonts.get(i3);
                    if (!font.getBaseFont().charExists(n4)) continue;
                    if (n3 != i3) {
                        if (stringBuffer.length() > 0 && n3 != -1) {
                            Chunk chunk = new Chunk(stringBuffer.toString(), (Font)this.fonts.get(n3));
                            phrase.add(chunk);
                            stringBuffer.setLength(0);
                        }
                        n3 = i3;
                    }
                    stringBuffer.append(c2);
                    stringBuffer.append(cArray[++i2]);
                    continue block0;
                }
                continue;
            }
            for (n4 = 0; n4 < n; ++n4) {
                font = (Font)this.fonts.get(n4);
                if (!font.getBaseFont().charExists(c2)) continue;
                if (n3 != n4) {
                    if (stringBuffer.length() > 0 && n3 != -1) {
                        Chunk chunk = new Chunk(stringBuffer.toString(), (Font)this.fonts.get(n3));
                        phrase.add(chunk);
                        stringBuffer.setLength(0);
                    }
                    n3 = n4;
                }
                stringBuffer.append(c2);
                continue block0;
            }
        }
        if (stringBuffer.length() > 0) {
            Chunk chunk = new Chunk(stringBuffer.toString(), (Font)this.fonts.get(n3 == -1 ? 0 : n3));
            phrase.add(chunk);
        }
        return phrase;
    }
}

