/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;

public class PdfFunction {
    protected PdfWriter writer;
    protected PdfIndirectReference reference;
    protected PdfDictionary dictionary;

    protected PdfFunction(PdfWriter pdfWriter) {
        this.writer = pdfWriter;
    }

    PdfIndirectReference getReference() {
        try {
            if (this.reference == null) {
                this.reference = this.writer.addToBody(this.dictionary).getIndirectReference();
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        return this.reference;
    }

    public static PdfFunction type0(PdfWriter pdfWriter, float[] fArray, float[] fArray2, int[] nArray, int n, int n2, float[] fArray3, float[] fArray4, byte[] byArray) {
        PdfFunction pdfFunction = new PdfFunction(pdfWriter);
        pdfFunction.dictionary = new PdfStream(byArray);
        ((PdfStream)pdfFunction.dictionary).flateCompress(pdfWriter.getCompressionLevel());
        pdfFunction.dictionary.put(PdfName.FUNCTIONTYPE, new PdfNumber(0));
        pdfFunction.dictionary.put(PdfName.DOMAIN, new PdfArray(fArray));
        pdfFunction.dictionary.put(PdfName.RANGE, new PdfArray(fArray2));
        pdfFunction.dictionary.put(PdfName.SIZE, new PdfArray(nArray));
        pdfFunction.dictionary.put(PdfName.BITSPERSAMPLE, new PdfNumber(n));
        if (n2 != 1) {
            pdfFunction.dictionary.put(PdfName.ORDER, new PdfNumber(n2));
        }
        if (fArray3 != null) {
            pdfFunction.dictionary.put(PdfName.ENCODE, new PdfArray(fArray3));
        }
        if (fArray4 != null) {
            pdfFunction.dictionary.put(PdfName.DECODE, new PdfArray(fArray4));
        }
        return pdfFunction;
    }

    public static PdfFunction type2(PdfWriter pdfWriter, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float f2) {
        PdfFunction pdfFunction = new PdfFunction(pdfWriter);
        pdfFunction.dictionary = new PdfDictionary();
        pdfFunction.dictionary.put(PdfName.FUNCTIONTYPE, new PdfNumber(2));
        pdfFunction.dictionary.put(PdfName.DOMAIN, new PdfArray(fArray));
        if (fArray2 != null) {
            pdfFunction.dictionary.put(PdfName.RANGE, new PdfArray(fArray2));
        }
        if (fArray3 != null) {
            pdfFunction.dictionary.put(PdfName.C0, new PdfArray(fArray3));
        }
        if (fArray4 != null) {
            pdfFunction.dictionary.put(PdfName.C1, new PdfArray(fArray4));
        }
        pdfFunction.dictionary.put(PdfName.N, new PdfNumber(f2));
        return pdfFunction;
    }

    public static PdfFunction type3(PdfWriter pdfWriter, float[] fArray, float[] fArray2, PdfFunction[] pdfFunctionArray, float[] fArray3, float[] fArray4) {
        PdfFunction pdfFunction = new PdfFunction(pdfWriter);
        pdfFunction.dictionary = new PdfDictionary();
        pdfFunction.dictionary.put(PdfName.FUNCTIONTYPE, new PdfNumber(3));
        pdfFunction.dictionary.put(PdfName.DOMAIN, new PdfArray(fArray));
        if (fArray2 != null) {
            pdfFunction.dictionary.put(PdfName.RANGE, new PdfArray(fArray2));
        }
        PdfArray pdfArray = new PdfArray();
        for (int i2 = 0; i2 < pdfFunctionArray.length; ++i2) {
            pdfArray.add(pdfFunctionArray[i2].getReference());
        }
        pdfFunction.dictionary.put(PdfName.FUNCTIONS, pdfArray);
        pdfFunction.dictionary.put(PdfName.BOUNDS, new PdfArray(fArray3));
        pdfFunction.dictionary.put(PdfName.ENCODE, new PdfArray(fArray4));
        return pdfFunction;
    }

    public static PdfFunction type4(PdfWriter pdfWriter, float[] fArray, float[] fArray2, String string) {
        byte[] byArray = new byte[string.length()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        PdfFunction pdfFunction = new PdfFunction(pdfWriter);
        pdfFunction.dictionary = new PdfStream(byArray);
        ((PdfStream)pdfFunction.dictionary).flateCompress(pdfWriter.getCompressionLevel());
        pdfFunction.dictionary.put(PdfName.FUNCTIONTYPE, new PdfNumber(4));
        pdfFunction.dictionary.put(PdfName.DOMAIN, new PdfArray(fArray));
        pdfFunction.dictionary.put(PdfName.RANGE, new PdfArray(fArray2));
        return pdfFunction;
    }
}

