/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfDashPattern;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;

public class TextField
extends BaseField {
    private String defaultText;
    private String[] choices;
    private String[] choiceExports;
    private int choiceSelection;
    private int topFirst;
    private float extraMarginLeft;
    private float extraMarginTop;
    private ArrayList substitutionFonts;
    private BaseFont extensionFont;

    public TextField(PdfWriter pdfWriter, Rectangle rectangle, String string) {
        super(pdfWriter, rectangle, string);
    }

    private static boolean checkRTL(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0590' || c2 >= '\u0780') continue;
            return true;
        }
        return false;
    }

    private static void changeFontSize(Phrase phrase, float f2) {
        for (int i2 = 0; i2 < phrase.size(); ++i2) {
            ((Chunk)phrase.get(i2)).getFont().setSize(f2);
        }
    }

    private Phrase composePhrase(String string, BaseFont baseFont, Color color, float f2) {
        Phrase phrase = null;
        if (this.extensionFont == null && (this.substitutionFonts == null || this.substitutionFonts.isEmpty())) {
            phrase = new Phrase(new Chunk(string, new Font(baseFont, f2, 0, color)));
        } else {
            FontSelector fontSelector = new FontSelector();
            fontSelector.addFont(new Font(baseFont, f2, 0, color));
            if (this.extensionFont != null) {
                fontSelector.addFont(new Font(this.extensionFont, f2, 0, color));
            }
            if (this.substitutionFonts != null) {
                for (int i2 = 0; i2 < this.substitutionFonts.size(); ++i2) {
                    fontSelector.addFont(new Font((BaseFont)this.substitutionFonts.get(i2), f2, 0, color));
                }
            }
            phrase = fontSelector.process(string);
        }
        return phrase;
    }

    public static String removeCRLF(String string) {
        if (string.indexOf(10) >= 0 || string.indexOf(13) >= 0) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(cArray.length);
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                char c2 = cArray[i2];
                if (c2 == '\n') {
                    stringBuffer.append(' ');
                    continue;
                }
                if (c2 == '\r') {
                    stringBuffer.append(' ');
                    if (i2 >= cArray.length - 1 || cArray[i2 + 1] != '\n') continue;
                    ++i2;
                    continue;
                }
                stringBuffer.append(c2);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String obfuscatePassword(String string) {
        char[] cArray = new char[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            cArray[i2] = 42;
        }
        return new String(cArray);
    }

    public PdfAppearance getAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.text == null || this.text.length() == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f2 = this.box.getHeight() - this.borderWidth * 2.0f - this.extraMarginTop;
        float f3 = this.borderWidth;
        if (bl) {
            f2 -= this.borderWidth * 2.0f;
            f3 *= 2.0f;
        }
        float f4 = Math.max(f3, 1.0f);
        float f5 = Math.min(f3, f4);
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f5, f5, this.box.getWidth() - 2.0f * f5, this.box.getHeight() - 2.0f * f5);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        String string = (this.options & 0x2000) != 0 ? TextField.obfuscatePassword(this.text) : ((this.options & 0x1000) == 0 ? TextField.removeCRLF(this.text) : this.text);
        BaseFont baseFont = this.getRealFont();
        Color color = this.textColor == null ? GrayColor.GRAYBLACK : this.textColor;
        int n = TextField.checkRTL(string) ? 2 : 1;
        float f6 = this.fontSize;
        Phrase phrase = this.composePhrase(string, baseFont, color, f6);
        if ((this.options & 0x1000) != 0) {
            float f7;
            float f8 = this.box.getWidth() - 4.0f * f4 - this.extraMarginLeft;
            float f9 = baseFont.getFontDescriptor(8, 1.0f) - baseFont.getFontDescriptor(6, 1.0f);
            ColumnText columnText = new ColumnText(null);
            if (f6 == 0.0f) {
                f6 = f2 / f9;
                if (f6 > 4.0f) {
                    if (f6 > 12.0f) {
                        f6 = 12.0f;
                    }
                    f7 = Math.max((f6 - 4.0f) / 10.0f, 0.2f);
                    columnText.setSimpleColumn(0.0f, -f2, f8, 0.0f);
                    columnText.setAlignment(this.alignment);
                    columnText.setRunDirection(n);
                    while (f6 > 4.0f) {
                        columnText.setYLine(0.0f);
                        TextField.changeFontSize(phrase, f6);
                        columnText.setText(phrase);
                        columnText.setLeading(f9 * f6);
                        int n2 = columnText.go(true);
                        if ((n2 & 2) == 0) break;
                        f6 -= f7;
                    }
                }
                if (f6 < 4.0f) {
                    f6 = 4.0f;
                }
            }
            TextField.changeFontSize(phrase, f6);
            columnText.setCanvas(pdfAppearance);
            f7 = f6 * f9;
            float f10 = f4 + f2 - baseFont.getFontDescriptor(8, f6);
            columnText.setSimpleColumn(this.extraMarginLeft + 2.0f * f4, -20000.0f, this.box.getWidth() - 2.0f * f4, f10 + f7);
            columnText.setLeading(f7);
            columnText.setAlignment(this.alignment);
            columnText.setRunDirection(n);
            columnText.setText(phrase);
            columnText.go();
        } else {
            float f11;
            float f12;
            if (f6 == 0.0f) {
                f12 = f2 / (baseFont.getFontDescriptor(7, 1.0f) - baseFont.getFontDescriptor(6, 1.0f));
                TextField.changeFontSize(phrase, 1.0f);
                f11 = ColumnText.getWidth(phrase, n, 0);
                f6 = f11 == 0.0f ? f12 : Math.min(f12, (this.box.getWidth() - this.extraMarginLeft - 4.0f * f4) / f11);
                if (f6 < 4.0f) {
                    f6 = 4.0f;
                }
            }
            TextField.changeFontSize(phrase, f6);
            f12 = f5 + (this.box.getHeight() - 2.0f * f5 - baseFont.getFontDescriptor(1, f6)) / 2.0f;
            if (f12 < f5) {
                f12 = f5;
            }
            if (f12 - f5 < -baseFont.getFontDescriptor(3, f6)) {
                f11 = -baseFont.getFontDescriptor(3, f6) + f5;
                float f13 = this.box.getHeight() - f5 - baseFont.getFontDescriptor(1, f6);
                f12 = Math.min(f11, Math.max(f12, f13));
            }
            if ((this.options & 0x1000000) != 0 && this.maxCharacterLength > 0) {
                int n3 = Math.min(this.maxCharacterLength, string.length());
                int n4 = 0;
                if (this.alignment == 2) {
                    n4 = this.maxCharacterLength - n3;
                } else if (this.alignment == 1) {
                    n4 = (this.maxCharacterLength - n3) / 2;
                }
                float f14 = (this.box.getWidth() - this.extraMarginLeft) / (float)this.maxCharacterLength;
                float f15 = f14 / 2.0f + (float)n4 * f14;
                if (this.textColor == null) {
                    pdfAppearance.setGrayFill(0.0f);
                } else {
                    pdfAppearance.setColorFill(this.textColor);
                }
                pdfAppearance.beginText();
                for (int i2 = 0; i2 < phrase.size(); ++i2) {
                    Chunk chunk = (Chunk)phrase.get(i2);
                    BaseFont baseFont2 = chunk.getFont().getBaseFont();
                    pdfAppearance.setFontAndSize(baseFont2, f6);
                    StringBuffer stringBuffer = chunk.append("");
                    for (int i3 = 0; i3 < stringBuffer.length(); ++i3) {
                        String string2 = stringBuffer.substring(i3, i3 + 1);
                        float f16 = baseFont2.getWidthPoint(string2, f6);
                        pdfAppearance.setTextMatrix(this.extraMarginLeft + f15 - f16 / 2.0f, f12 - this.extraMarginTop);
                        pdfAppearance.showText(string2);
                        f15 += f14;
                    }
                }
                pdfAppearance.endText();
            } else {
                switch (this.alignment) {
                    case 2: {
                        f11 = this.extraMarginLeft + this.box.getWidth() - 2.0f * f4;
                        break;
                    }
                    case 1: {
                        f11 = this.extraMarginLeft + this.box.getWidth() / 2.0f;
                        break;
                    }
                    default: {
                        f11 = this.extraMarginLeft + 2.0f * f4;
                    }
                }
                ColumnText.showTextAligned(pdfAppearance, this.alignment, phrase, f11, f12 - this.extraMarginTop, 0.0f, n, 0);
            }
        }
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    PdfAppearance getListAppearance() throws IOException, DocumentException {
        PdfAppearance pdfAppearance = this.getBorderAppearance();
        pdfAppearance.beginVariableText();
        if (this.choices == null || this.choices.length == 0) {
            pdfAppearance.endVariableText();
            return pdfAppearance;
        }
        int n = this.choiceSelection;
        if (n >= this.choices.length) {
            n = this.choices.length - 1;
        }
        if (n < 0) {
            n = 0;
        }
        BaseFont baseFont = this.getRealFont();
        float f2 = this.fontSize;
        if (f2 == 0.0f) {
            f2 = 12.0f;
        }
        boolean bl = this.borderStyle == 2 || this.borderStyle == 3;
        float f3 = this.box.getHeight() - this.borderWidth * 2.0f;
        float f4 = this.borderWidth;
        if (bl) {
            f3 -= this.borderWidth * 2.0f;
            f4 *= 2.0f;
        }
        float f5 = baseFont.getFontDescriptor(8, f2) - baseFont.getFontDescriptor(6, f2);
        int n2 = (int)(f3 / f5) + 1;
        int n3 = 0;
        int n4 = 0;
        n4 = n + n2 / 2 + 1;
        n3 = n4 - n2;
        if (n3 < 0) {
            n4 += n3;
            n3 = 0;
        }
        if ((n4 = n3 + n2) > this.choices.length) {
            n4 = this.choices.length;
        }
        this.topFirst = n3;
        pdfAppearance.saveState();
        pdfAppearance.rectangle(f4, f4, this.box.getWidth() - 2.0f * f4, this.box.getHeight() - 2.0f * f4);
        pdfAppearance.clip();
        pdfAppearance.newPath();
        Color color = this.textColor == null ? GrayColor.GRAYBLACK : this.textColor;
        pdfAppearance.setColorFill(new Color(10, 36, 106));
        pdfAppearance.rectangle(f4, f4 + f3 - (float)(n - n3 + 1) * f5, this.box.getWidth() - 2.0f * f4, f5);
        pdfAppearance.fill();
        float f6 = f4 * 2.0f;
        float f7 = f4 + f3 - baseFont.getFontDescriptor(8, f2);
        int n5 = n3;
        while (n5 < n4) {
            String string = this.choices[n5];
            int n6 = TextField.checkRTL(string) ? 2 : 1;
            string = TextField.removeCRLF(string);
            Phrase phrase = this.composePhrase(string, baseFont, n5 == n ? GrayColor.GRAYWHITE : color, f2);
            ColumnText.showTextAligned(pdfAppearance, 0, phrase, f6, f7, 0.0f, n6, 0);
            ++n5;
            f7 -= f5;
        }
        pdfAppearance.restoreState();
        pdfAppearance.endVariableText();
        return pdfAppearance;
    }

    public PdfFormField getTextField() throws IOException, DocumentException {
        if (this.maxCharacterLength <= 0) {
            this.options &= 0xFEFFFFFF;
        }
        if ((this.options & 0x1000000) != 0) {
            this.options &= 0xFFFFEFFF;
        }
        PdfFormField pdfFormField = PdfFormField.createTextField(this.writer, false, false, this.maxCharacterLength);
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        switch (this.alignment) {
            case 1: {
                pdfFormField.setQuadding(1);
                break;
            }
            case 2: {
                pdfFormField.setQuadding(2);
            }
        }
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if (!"".equals(this.text)) {
                pdfFormField.setValueAsString(this.text);
            }
            if (this.defaultText != null) {
                pdfFormField.setDefaultValueAsString(this.defaultText);
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 0x1000) != 0) {
                pdfFormField.setFieldFlags(4096);
            }
            if ((this.options & 0x800000) != 0) {
                pdfFormField.setFieldFlags(0x800000);
            }
            if ((this.options & 0x2000) != 0) {
                pdfFormField.setFieldFlags(8192);
            }
            if ((this.options & 0x100000) != 0) {
                pdfFormField.setFieldFlags(0x100000);
            }
            if ((this.options & 0x400000) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
            if ((this.options & 0x1000000) != 0) {
                pdfFormField.setFieldFlags(0x1000000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        PdfAppearance pdfAppearance = this.getAppearance();
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    public PdfFormField getComboField() throws IOException, DocumentException {
        return this.getChoiceField(false);
    }

    public PdfFormField getListField() throws IOException, DocumentException {
        return this.getChoiceField(true);
    }

    protected PdfFormField getChoiceField(boolean bl) throws IOException, DocumentException {
        PdfAppearance pdfAppearance;
        int n;
        this.options &= 0xFEFFEFFF;
        String[] stringArray = this.choices;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if ((n = this.choiceSelection) >= stringArray.length) {
            n = stringArray.length - 1;
        }
        if (this.text == null) {
            this.text = "";
        }
        if (n >= 0) {
            this.text = stringArray[n];
        }
        if (n < 0) {
            n = 0;
        }
        PdfFormField pdfFormField = null;
        String[][] stringArray2 = null;
        if (this.choiceExports == null) {
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray, n) : PdfFormField.createCombo(this.writer, (this.options & 0x40000) != 0, stringArray, n);
        } else {
            int n2;
            stringArray2 = new String[stringArray.length][2];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                String string = stringArray[n2];
                stringArray2[n2][1] = string;
                stringArray2[n2][0] = string;
            }
            n2 = Math.min(stringArray.length, this.choiceExports.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.choiceExports[i2] == null) continue;
                stringArray2[i2][0] = this.choiceExports[i2];
            }
            pdfFormField = bl ? PdfFormField.createList(this.writer, stringArray2, n) : PdfFormField.createCombo(this.writer, (this.options & 0x40000) != 0, stringArray2, n);
        }
        pdfFormField.setWidget(this.box, PdfAnnotation.HIGHLIGHT_INVERT);
        if (this.rotation != 0) {
            pdfFormField.setMKRotation(this.rotation);
        }
        if (this.fieldName != null) {
            pdfFormField.setFieldName(this.fieldName);
            if (stringArray.length > 0) {
                if (stringArray2 != null) {
                    pdfFormField.setValueAsString(stringArray2[n][0]);
                    pdfFormField.setDefaultValueAsString(stringArray2[n][0]);
                } else {
                    pdfFormField.setValueAsString(this.text);
                    pdfFormField.setDefaultValueAsString(this.text);
                }
            }
            if ((this.options & 1) != 0) {
                pdfFormField.setFieldFlags(1);
            }
            if ((this.options & 2) != 0) {
                pdfFormField.setFieldFlags(2);
            }
            if ((this.options & 0x400000) != 0) {
                pdfFormField.setFieldFlags(0x400000);
            }
        }
        pdfFormField.setBorderStyle(new PdfBorderDictionary(this.borderWidth, this.borderStyle, new PdfDashPattern(3.0f)));
        if (bl) {
            pdfAppearance = this.getListAppearance();
            if (this.topFirst > 0) {
                pdfFormField.put(PdfName.TI, new PdfNumber(this.topFirst));
            }
        } else {
            pdfAppearance = this.getAppearance();
        }
        pdfFormField.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pdfAppearance);
        PdfAppearance pdfAppearance2 = (PdfAppearance)pdfAppearance.getDuplicate();
        pdfAppearance2.setFontAndSize(this.getRealFont(), this.fontSize);
        if (this.textColor == null) {
            pdfAppearance2.setGrayFill(0.0f);
        } else {
            pdfAppearance2.setColorFill(this.textColor);
        }
        pdfFormField.setDefaultAppearanceString(pdfAppearance2);
        if (this.borderColor != null) {
            pdfFormField.setMKBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            pdfFormField.setMKBackgroundColor(this.backgroundColor);
        }
        switch (this.visibility) {
            case 1: {
                pdfFormField.setFlags(6);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                pdfFormField.setFlags(36);
                break;
            }
            default: {
                pdfFormField.setFlags(4);
            }
        }
        return pdfFormField;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String string) {
        this.defaultText = string;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public void setChoices(String[] stringArray) {
        this.choices = stringArray;
    }

    public String[] getChoiceExports() {
        return this.choiceExports;
    }

    public void setChoiceExports(String[] stringArray) {
        this.choiceExports = stringArray;
    }

    public int getChoiceSelection() {
        return this.choiceSelection;
    }

    public void setChoiceSelection(int n) {
        this.choiceSelection = n;
    }

    int getTopFirst() {
        return this.topFirst;
    }

    public void setExtraMargin(float f2, float f3) {
        this.extraMarginLeft = f2;
        this.extraMarginTop = f3;
    }

    public ArrayList getSubstitutionFonts() {
        return this.substitutionFonts;
    }

    public void setSubstitutionFonts(ArrayList arrayList) {
        this.substitutionFonts = arrayList;
    }

    public BaseFont getExtensionFont() {
        return this.extensionFont;
    }

    public void setExtensionFont(BaseFont baseFont) {
        this.extensionFont = baseFont;
    }
}

