/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.codec.wmf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.codec.BmpImage;
import com.lowagie.text.pdf.codec.wmf.InputMeta;
import com.lowagie.text.pdf.codec.wmf.MetaBrush;
import com.lowagie.text.pdf.codec.wmf.MetaFont;
import com.lowagie.text.pdf.codec.wmf.MetaObject;
import com.lowagie.text.pdf.codec.wmf.MetaPen;
import com.lowagie.text.pdf.codec.wmf.MetaState;
import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class MetaDo {
    public static final int META_SETBKCOLOR = 513;
    public static final int META_SETBKMODE = 258;
    public static final int META_SETMAPMODE = 259;
    public static final int META_SETROP2 = 260;
    public static final int META_SETRELABS = 261;
    public static final int META_SETPOLYFILLMODE = 262;
    public static final int META_SETSTRETCHBLTMODE = 263;
    public static final int META_SETTEXTCHAREXTRA = 264;
    public static final int META_SETTEXTCOLOR = 521;
    public static final int META_SETTEXTJUSTIFICATION = 522;
    public static final int META_SETWINDOWORG = 523;
    public static final int META_SETWINDOWEXT = 524;
    public static final int META_SETVIEWPORTORG = 525;
    public static final int META_SETVIEWPORTEXT = 526;
    public static final int META_OFFSETWINDOWORG = 527;
    public static final int META_SCALEWINDOWEXT = 1040;
    public static final int META_OFFSETVIEWPORTORG = 529;
    public static final int META_SCALEVIEWPORTEXT = 1042;
    public static final int META_LINETO = 531;
    public static final int META_MOVETO = 532;
    public static final int META_EXCLUDECLIPRECT = 1045;
    public static final int META_INTERSECTCLIPRECT = 1046;
    public static final int META_ARC = 2071;
    public static final int META_ELLIPSE = 1048;
    public static final int META_FLOODFILL = 1049;
    public static final int META_PIE = 2074;
    public static final int META_RECTANGLE = 1051;
    public static final int META_ROUNDRECT = 1564;
    public static final int META_PATBLT = 1565;
    public static final int META_SAVEDC = 30;
    public static final int META_SETPIXEL = 1055;
    public static final int META_OFFSETCLIPRGN = 544;
    public static final int META_TEXTOUT = 1313;
    public static final int META_BITBLT = 2338;
    public static final int META_STRETCHBLT = 2851;
    public static final int META_POLYGON = 804;
    public static final int META_POLYLINE = 805;
    public static final int META_ESCAPE = 1574;
    public static final int META_RESTOREDC = 295;
    public static final int META_FILLREGION = 552;
    public static final int META_FRAMEREGION = 1065;
    public static final int META_INVERTREGION = 298;
    public static final int META_PAINTREGION = 299;
    public static final int META_SELECTCLIPREGION = 300;
    public static final int META_SELECTOBJECT = 301;
    public static final int META_SETTEXTALIGN = 302;
    public static final int META_CHORD = 2096;
    public static final int META_SETMAPPERFLAGS = 561;
    public static final int META_EXTTEXTOUT = 2610;
    public static final int META_SETDIBTODEV = 3379;
    public static final int META_SELECTPALETTE = 564;
    public static final int META_REALIZEPALETTE = 53;
    public static final int META_ANIMATEPALETTE = 1078;
    public static final int META_SETPALENTRIES = 55;
    public static final int META_POLYPOLYGON = 1336;
    public static final int META_RESIZEPALETTE = 313;
    public static final int META_DIBBITBLT = 2368;
    public static final int META_DIBSTRETCHBLT = 2881;
    public static final int META_DIBCREATEPATTERNBRUSH = 322;
    public static final int META_STRETCHDIB = 3907;
    public static final int META_EXTFLOODFILL = 1352;
    public static final int META_DELETEOBJECT = 496;
    public static final int META_CREATEPALETTE = 247;
    public static final int META_CREATEPATTERNBRUSH = 505;
    public static final int META_CREATEPENINDIRECT = 762;
    public static final int META_CREATEFONTINDIRECT = 763;
    public static final int META_CREATEBRUSHINDIRECT = 764;
    public static final int META_CREATEREGION = 1791;
    public PdfContentByte cb;
    public InputMeta in;
    int left;
    int top;
    int right;
    int bottom;
    int inch;
    MetaState state = new MetaState();

    public MetaDo(InputStream inputStream, PdfContentByte pdfContentByte) {
        this.cb = pdfContentByte;
        this.in = new InputMeta(inputStream);
    }

    public void readAll() throws IOException, DocumentException {
        if (this.in.readInt() != -1698247209) {
            throw new DocumentException("Not a placeable windows metafile");
        }
        this.in.readWord();
        this.left = this.in.readShort();
        this.top = this.in.readShort();
        this.right = this.in.readShort();
        this.bottom = this.in.readShort();
        this.inch = this.in.readWord();
        this.state.setScalingX((float)(this.right - this.left) / (float)this.inch * 72.0f);
        this.state.setScalingY((float)(this.bottom - this.top) / (float)this.inch * 72.0f);
        this.state.setOffsetWx(this.left);
        this.state.setOffsetWy(this.top);
        this.state.setExtentWx(this.right - this.left);
        this.state.setExtentWy(this.bottom - this.top);
        this.in.readInt();
        this.in.readWord();
        this.in.skip(18);
        this.cb.setLineCap(1);
        this.cb.setLineJoin(1);
        while (true) {
            int n = this.in.getLength();
            int n2 = this.in.readInt();
            if (n2 < 3) break;
            int n3 = this.in.readWord();
            switch (n3) {
                case 0: {
                    break;
                }
                case 247: 
                case 322: 
                case 1791: {
                    this.state.addMetaObject(new MetaObject());
                    break;
                }
                case 762: {
                    MetaPen metaPen = new MetaPen();
                    metaPen.init(this.in);
                    this.state.addMetaObject(metaPen);
                    break;
                }
                case 764: {
                    MetaBrush metaBrush = new MetaBrush();
                    metaBrush.init(this.in);
                    this.state.addMetaObject(metaBrush);
                    break;
                }
                case 763: {
                    MetaFont metaFont = new MetaFont();
                    metaFont.init(this.in);
                    this.state.addMetaObject(metaFont);
                    break;
                }
                case 301: {
                    int n4 = this.in.readWord();
                    this.state.selectMetaObject(n4, this.cb);
                    break;
                }
                case 496: {
                    int n5 = this.in.readWord();
                    this.state.deleteMetaObject(n5);
                    break;
                }
                case 30: {
                    this.state.saveState(this.cb);
                    break;
                }
                case 295: {
                    int n6 = this.in.readShort();
                    this.state.restoreState(n6, this.cb);
                    break;
                }
                case 523: {
                    this.state.setOffsetWy(this.in.readShort());
                    this.state.setOffsetWx(this.in.readShort());
                    break;
                }
                case 524: {
                    this.state.setExtentWy(this.in.readShort());
                    this.state.setExtentWx(this.in.readShort());
                    break;
                }
                case 532: {
                    int n7 = this.in.readShort();
                    Point point = new Point(this.in.readShort(), n7);
                    this.state.setCurrentPoint(point);
                    break;
                }
                case 531: {
                    int n8 = this.in.readShort();
                    int n9 = this.in.readShort();
                    Point point = this.state.getCurrentPoint();
                    this.cb.moveTo(this.state.transformX(point.x), this.state.transformY(point.y));
                    this.cb.lineTo(this.state.transformX(n9), this.state.transformY(n8));
                    this.cb.stroke();
                    this.state.setCurrentPoint(new Point(n9, n8));
                    break;
                }
                case 805: {
                    this.state.setLineJoinPolygon(this.cb);
                    int n10 = this.in.readWord();
                    int n11 = this.in.readShort();
                    int n12 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n11), this.state.transformY(n12));
                    for (int i2 = 1; i2 < n10; ++i2) {
                        n11 = this.in.readShort();
                        n12 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n11), this.state.transformY(n12));
                    }
                    this.cb.stroke();
                    break;
                }
                case 804: {
                    if (this.isNullStrokeFill(false)) break;
                    int n13 = this.in.readWord();
                    int n14 = this.in.readShort();
                    int n15 = this.in.readShort();
                    this.cb.moveTo(this.state.transformX(n14), this.state.transformY(n15));
                    for (int i3 = 1; i3 < n13; ++i3) {
                        int n16 = this.in.readShort();
                        int n17 = this.in.readShort();
                        this.cb.lineTo(this.state.transformX(n16), this.state.transformY(n17));
                    }
                    this.cb.lineTo(this.state.transformX(n14), this.state.transformY(n15));
                    this.strokeAndFill();
                    break;
                }
                case 1336: {
                    int n18;
                    if (this.isNullStrokeFill(false)) break;
                    int n19 = this.in.readWord();
                    int[] nArray = new int[n19];
                    for (n18 = 0; n18 < nArray.length; ++n18) {
                        nArray[n18] = this.in.readWord();
                    }
                    for (n18 = 0; n18 < nArray.length; ++n18) {
                        int n20 = nArray[n18];
                        int n21 = this.in.readShort();
                        int n22 = this.in.readShort();
                        this.cb.moveTo(this.state.transformX(n21), this.state.transformY(n22));
                        for (int i4 = 1; i4 < n20; ++i4) {
                            int n23 = this.in.readShort();
                            int n24 = this.in.readShort();
                            this.cb.lineTo(this.state.transformX(n23), this.state.transformY(n24));
                        }
                        this.cb.lineTo(this.state.transformX(n21), this.state.transformY(n22));
                    }
                    this.strokeAndFill();
                    break;
                }
                case 1048: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    int n25 = this.in.readShort();
                    int n26 = this.in.readShort();
                    int n27 = this.in.readShort();
                    int n28 = this.in.readShort();
                    this.cb.arc(this.state.transformX(n28), this.state.transformY(n25), this.state.transformX(n26), this.state.transformY(n27), 0.0f, 360.0f);
                    this.strokeAndFill();
                    break;
                }
                case 2071: {
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f2 = this.state.transformY(this.in.readShort());
                    float f3 = this.state.transformX(this.in.readShort());
                    float f4 = this.state.transformY(this.in.readShort());
                    float f5 = this.state.transformX(this.in.readShort());
                    float f6 = this.state.transformY(this.in.readShort());
                    float f7 = this.state.transformX(this.in.readShort());
                    float f8 = this.state.transformY(this.in.readShort());
                    float f9 = this.state.transformX(this.in.readShort());
                    float f10 = (f7 + f9) / 2.0f;
                    float f11 = (f8 + f6) / 2.0f;
                    float f12 = MetaDo.getArc(f10, f11, f5, f4);
                    float f13 = MetaDo.getArc(f10, f11, f3, f2);
                    if ((f13 -= f12) <= 0.0f) {
                        f13 += 360.0f;
                    }
                    this.cb.arc(f9, f6, f7, f8, f12, f13);
                    this.cb.stroke();
                    break;
                }
                case 2074: {
                    int n29;
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f14 = this.state.transformY(this.in.readShort());
                    float f15 = this.state.transformX(this.in.readShort());
                    float f16 = this.state.transformY(this.in.readShort());
                    float f17 = this.state.transformX(this.in.readShort());
                    float f18 = this.state.transformY(this.in.readShort());
                    float f19 = this.state.transformX(this.in.readShort());
                    float f8 = this.state.transformY(this.in.readShort());
                    float f9 = this.state.transformX(this.in.readShort());
                    float f10 = (f19 + f9) / 2.0f;
                    float f11 = (f8 + f18) / 2.0f;
                    float f20 = MetaDo.getArc(f10, f11, f17, f16);
                    float f21 = MetaDo.getArc(f10, f11, f15, f14);
                    if ((f21 -= f20) <= 0.0f) {
                        f21 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f9, f18, f19, f8, f20, f21)).isEmpty()) break;
                    float[] fArray = (float[])arrayList.get(0);
                    this.cb.moveTo(f10, f11);
                    this.cb.lineTo(fArray[0], fArray[1]);
                    for (n29 = 0; n29 < arrayList.size(); ++n29) {
                        fArray = (float[])arrayList.get(n29);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    }
                    this.cb.lineTo(f10, f11);
                    this.strokeAndFill();
                    break;
                }
                case 2096: {
                    int n29;
                    ArrayList arrayList;
                    if (this.isNullStrokeFill(this.state.getLineNeutral())) break;
                    float f22 = this.state.transformY(this.in.readShort());
                    float f23 = this.state.transformX(this.in.readShort());
                    float f24 = this.state.transformY(this.in.readShort());
                    float f25 = this.state.transformX(this.in.readShort());
                    float f26 = this.state.transformY(this.in.readShort());
                    float f27 = this.state.transformX(this.in.readShort());
                    float f8 = this.state.transformY(this.in.readShort());
                    float f9 = this.state.transformX(this.in.readShort());
                    float f10 = (f27 + f9) / 2.0f;
                    float f11 = (f8 + f26) / 2.0f;
                    float f28 = MetaDo.getArc(f10, f11, f25, f24);
                    float f29 = MetaDo.getArc(f10, f11, f23, f22);
                    if ((f29 -= f28) <= 0.0f) {
                        f29 += 360.0f;
                    }
                    if ((arrayList = PdfContentByte.bezierArc(f9, f26, f27, f8, f28, f29)).isEmpty()) break;
                    float[] fArray = (float[])arrayList.get(0);
                    f10 = fArray[0];
                    f11 = fArray[1];
                    this.cb.moveTo(f10, f11);
                    for (n29 = 0; n29 < arrayList.size(); ++n29) {
                        fArray = (float[])arrayList.get(n29);
                        this.cb.curveTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    }
                    this.cb.lineTo(f10, f11);
                    this.strokeAndFill();
                    break;
                }
                case 1051: {
                    if (this.isNullStrokeFill(true)) break;
                    float f30 = this.state.transformY(this.in.readShort());
                    float f31 = this.state.transformX(this.in.readShort());
                    float f32 = this.state.transformY(this.in.readShort());
                    float f33 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f33, f30, f31 - f33, f32 - f30);
                    this.strokeAndFill();
                    break;
                }
                case 1564: {
                    if (this.isNullStrokeFill(true)) break;
                    float f34 = this.state.transformY(0) - this.state.transformY(this.in.readShort());
                    float f35 = this.state.transformX(this.in.readShort()) - this.state.transformX(0);
                    float f36 = this.state.transformY(this.in.readShort());
                    float f37 = this.state.transformX(this.in.readShort());
                    float f38 = this.state.transformY(this.in.readShort());
                    float f39 = this.state.transformX(this.in.readShort());
                    this.cb.roundRectangle(f39, f36, f37 - f39, f38 - f36, (f34 + f35) / 4.0f);
                    this.strokeAndFill();
                    break;
                }
                case 1046: {
                    float f40 = this.state.transformY(this.in.readShort());
                    float f41 = this.state.transformX(this.in.readShort());
                    float f42 = this.state.transformY(this.in.readShort());
                    float f43 = this.state.transformX(this.in.readShort());
                    this.cb.rectangle(f43, f40, f41 - f43, f42 - f40);
                    this.cb.eoClip();
                    this.cb.newPath();
                    break;
                }
                case 2610: {
                    String string;
                    byte by;
                    int n30;
                    int n31 = this.in.readShort();
                    int n32 = this.in.readShort();
                    int n33 = this.in.readWord();
                    int n34 = this.in.readWord();
                    int n35 = 0;
                    int n36 = 0;
                    int n37 = 0;
                    int n38 = 0;
                    if ((n34 & 6) != 0) {
                        n35 = this.in.readShort();
                        n36 = this.in.readShort();
                        n37 = this.in.readShort();
                        n38 = this.in.readShort();
                    }
                    byte[] byArray = new byte[n33];
                    for (n30 = 0; n30 < n33 && (by = (byte)this.in.readByte()) != 0; ++n30) {
                        byArray[n30] = by;
                    }
                    try {
                        string = new String(byArray, 0, n30, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n30);
                    }
                    this.outputText(n32, n31, n34, n35, n36, n37, n38, string);
                    break;
                }
                case 1313: {
                    String string;
                    byte by;
                    int n39;
                    int n40 = this.in.readWord();
                    byte[] byArray = new byte[n40];
                    for (n39 = 0; n39 < n40 && (by = (byte)this.in.readByte()) != 0; ++n39) {
                        byArray[n39] = by;
                    }
                    try {
                        string = new String(byArray, 0, n39, "Cp1252");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string = new String(byArray, 0, n39);
                    }
                    n40 = n40 + 1 & 0xFFFE;
                    this.in.skip(n40 - n39);
                    int n41 = this.in.readShort();
                    int n42 = this.in.readShort();
                    this.outputText(n42, n41, 0, 0, 0, 0, 0, string);
                    break;
                }
                case 513: {
                    this.state.setCurrentBackgroundColor(this.in.readColor());
                    break;
                }
                case 521: {
                    this.state.setCurrentTextColor(this.in.readColor());
                    break;
                }
                case 302: {
                    this.state.setTextAlign(this.in.readWord());
                    break;
                }
                case 258: {
                    this.state.setBackgroundMode(this.in.readWord());
                    break;
                }
                case 262: {
                    this.state.setPolyFillMode(this.in.readWord());
                    break;
                }
                case 1055: {
                    Color color = this.in.readColor();
                    int n43 = this.in.readShort();
                    int n44 = this.in.readShort();
                    this.cb.saveState();
                    this.cb.setColorFill(color);
                    this.cb.rectangle(this.state.transformX(n44), this.state.transformY(n43), 0.2f, 0.2f);
                    this.cb.fill();
                    this.cb.restoreState();
                    break;
                }
                case 2881: 
                case 3907: {
                    int n45 = this.in.readInt();
                    if (n3 == 3907) {
                        this.in.readWord();
                    }
                    int n46 = this.in.readShort();
                    int n47 = this.in.readShort();
                    int n48 = this.in.readShort();
                    int n49 = this.in.readShort();
                    float f44 = this.state.transformY(this.in.readShort()) - this.state.transformY(0);
                    float f8 = this.state.transformX(this.in.readShort()) - this.state.transformX(0);
                    float f9 = this.state.transformY(this.in.readShort());
                    float f10 = this.state.transformX(this.in.readShort());
                    byte[] byArray = new byte[n2 * 2 - (this.in.getLength() - n)];
                    for (int i5 = 0; i5 < byArray.length; ++i5) {
                        byArray[i5] = (byte)this.in.readByte();
                    }
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        Image image = BmpImage.getImage(byteArrayInputStream, true, byArray.length);
                        this.cb.saveState();
                        this.cb.rectangle(f10, f9, f8, f44);
                        this.cb.clip();
                        this.cb.newPath();
                        image.scaleAbsolute(f8 * image.getWidth() / (float)n47, -f44 * image.getHeight() / (float)n46);
                        image.setAbsolutePosition(f10 - f8 * (float)n49 / (float)n47, f9 + f44 * (float)n48 / (float)n46 - image.getScaledHeight());
                        this.cb.addImage(image);
                        this.cb.restoreState();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.in.skip(n2 * 2 - (this.in.getLength() - n));
        }
        this.state.cleanup(this.cb);
    }

    public void outputText(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string) {
        Color color;
        MetaFont metaFont = this.state.getCurrentFont();
        float f2 = this.state.transformX(n);
        float f3 = this.state.transformY(n2);
        float f4 = this.state.transformAngle(metaFont.getAngle());
        float f5 = (float)Math.sin(f4);
        float f6 = (float)Math.cos(f4);
        float f7 = metaFont.getFontSize(this.state);
        BaseFont baseFont = metaFont.getFont();
        int n8 = this.state.getTextAlign();
        float f8 = baseFont.getWidthPoint(string, f7);
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = baseFont.getFontDescriptor(3, f7);
        float f12 = baseFont.getFontDescriptor(8, f7);
        this.cb.saveState();
        this.cb.concatCTM(f6, f5, -f5, f6, f2, f3);
        if ((n8 & 6) == 6) {
            f9 = -f8 / 2.0f;
        } else if ((n8 & 2) == 2) {
            f9 = -f8;
        }
        f10 = (n8 & 0x18) == 24 ? 0.0f : ((n8 & 8) == 8 ? -f11 : -f12);
        if (this.state.getBackgroundMode() == 2) {
            color = this.state.getCurrentBackgroundColor();
            this.cb.setColorFill(color);
            this.cb.rectangle(f9, f10 + f11, f8, f12 - f11);
            this.cb.fill();
        }
        color = this.state.getCurrentTextColor();
        this.cb.setColorFill(color);
        this.cb.beginText();
        this.cb.setFontAndSize(baseFont, f7);
        this.cb.setTextMatrix(f9, f10);
        this.cb.showText(string);
        this.cb.endText();
        if (metaFont.isUnderline()) {
            this.cb.rectangle(f9, f10 - f7 / 4.0f, f8, f7 / 15.0f);
            this.cb.fill();
        }
        if (metaFont.isStrikeout()) {
            this.cb.rectangle(f9, f10 + f7 / 3.0f, f8, f7 / 15.0f);
            this.cb.fill();
        }
        this.cb.restoreState();
    }

    public boolean isNullStrokeFill(boolean bl) {
        boolean bl2;
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        boolean bl3 = metaPen.getStyle() == 5;
        int n = metaBrush.getStyle();
        boolean bl4 = n == 0 || n == 2 && this.state.getBackgroundMode() == 2;
        boolean bl5 = bl2 = bl3 && !bl4;
        if (!bl3) {
            if (bl) {
                this.state.setLineJoinRectangle(this.cb);
            } else {
                this.state.setLineJoinPolygon(this.cb);
            }
        }
        return bl2;
    }

    public void strokeAndFill() {
        MetaPen metaPen = this.state.getCurrentPen();
        MetaBrush metaBrush = this.state.getCurrentBrush();
        int n = metaPen.getStyle();
        int n2 = metaBrush.getStyle();
        if (n == 5) {
            this.cb.closePath();
            if (this.state.getPolyFillMode() == 1) {
                this.cb.eoFill();
            } else {
                this.cb.fill();
            }
        } else {
            boolean bl;
            boolean bl2 = bl = n2 == 0 || n2 == 2 && this.state.getBackgroundMode() == 2;
            if (bl) {
                if (this.state.getPolyFillMode() == 1) {
                    this.cb.closePathEoFillStroke();
                } else {
                    this.cb.closePathFillStroke();
                }
            } else {
                this.cb.closePathStroke();
            }
        }
    }

    static float getArc(float f2, float f3, float f4, float f5) {
        double d2 = Math.atan2(f5 - f3, f4 - f2);
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        return (float)(d2 / Math.PI * 180.0);
    }

    public static byte[] wrapBMP(Image image) throws IOException {
        if (image.getOriginalType() != 4) {
            throw new IOException("Only BMP can be wrapped in WMF.");
        }
        byte[] byArray = null;
        if (image.getOriginalData() == null) {
            InputStream inputStream = image.getUrl().openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            byArray = image.getOriginalData();
        }
        int n = byArray.length - 14 + 1 >>> 1;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MetaDo.writeWord(byteArrayOutputStream, 1);
        MetaDo.writeWord(byteArrayOutputStream, 9);
        MetaDo.writeWord(byteArrayOutputStream, 768);
        MetaDo.writeDWord(byteArrayOutputStream, 23 + (13 + n) + 3);
        MetaDo.writeWord(byteArrayOutputStream, 1);
        MetaDo.writeDWord(byteArrayOutputStream, 14 + n);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeDWord(byteArrayOutputStream, 4);
        MetaDo.writeWord(byteArrayOutputStream, 259);
        MetaDo.writeWord(byteArrayOutputStream, 8);
        MetaDo.writeDWord(byteArrayOutputStream, 5);
        MetaDo.writeWord(byteArrayOutputStream, 523);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeDWord(byteArrayOutputStream, 5);
        MetaDo.writeWord(byteArrayOutputStream, 524);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getHeight());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getWidth());
        MetaDo.writeDWord(byteArrayOutputStream, 13 + n);
        MetaDo.writeWord(byteArrayOutputStream, 2881);
        MetaDo.writeDWord(byteArrayOutputStream, 0xCC0020);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getHeight());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getWidth());
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getHeight());
        MetaDo.writeWord(byteArrayOutputStream, (int)image.getWidth());
        MetaDo.writeWord(byteArrayOutputStream, 0);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        byteArrayOutputStream.write(byArray, 14, byArray.length - 14);
        if ((byArray.length & 1) == 1) {
            byteArrayOutputStream.write(0);
        }
        MetaDo.writeDWord(byteArrayOutputStream, 3);
        MetaDo.writeWord(byteArrayOutputStream, 0);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeWord(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
    }

    public static void writeDWord(OutputStream outputStream, int n) throws IOException {
        MetaDo.writeWord(outputStream, n & 0xFFFF);
        MetaDo.writeWord(outputStream, n >>> 16 & 0xFFFF);
    }
}

