/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.ms.outlook.item;

import com.moyosoft.connector.com.ComUtil;
import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.com.Dispatch;
import com.moyosoft.connector.com.MapiProp;
import com.moyosoft.connector.com.MapiPropertyValue;
import com.moyosoft.connector.com.Variant;
import com.moyosoft.connector.ms.outlook.appointment.OutlookAppointment;
import com.moyosoft.connector.ms.outlook.contact.OutlookContact;
import com.moyosoft.connector.ms.outlook.distlist.OutlookDistributionList;
import com.moyosoft.connector.ms.outlook.document.OutlookDocument;
import com.moyosoft.connector.ms.outlook.folder.OutlookFolder;
import com.moyosoft.connector.ms.outlook.item.DefaultOutlookItem;
import com.moyosoft.connector.ms.outlook.item.LinksCollection;
import com.moyosoft.connector.ms.outlook.item.OutlookItemID;
import com.moyosoft.connector.ms.outlook.item.OutlookItemType;
import com.moyosoft.connector.ms.outlook.item.SaveAsType;
import com.moyosoft.connector.ms.outlook.journal.OutlookJournal;
import com.moyosoft.connector.ms.outlook.mail.OutlookMail;
import com.moyosoft.connector.ms.outlook.mail.OutlookReport;
import com.moyosoft.connector.ms.outlook.meeting.OutlookMeeting;
import com.moyosoft.connector.ms.outlook.note.OutlookNote;
import com.moyosoft.connector.ms.outlook.post.OutlookPost;
import com.moyosoft.connector.ms.outlook.properties.PropertyAccessor;
import com.moyosoft.connector.ms.outlook.remote.OutlookRemoteItem;
import com.moyosoft.connector.ms.outlook.task.OutlookTask;
import com.moyosoft.connector.ms.outlook.task.OutlookTaskRequest;
import com.moyosoft.connector.ms.outlook.util.Mapi;
import com.moyosoft.connector.ms.outlook.util.ObjectClass;
import java.io.File;
import java.util.Date;

public abstract class OutlookItem {
    protected Dispatch mDispatch;
    private OutlookItemID a = null;
    private MapiProp b = null;
    private PropertyAccessor c = null;
    private boolean d = false;

    public static OutlookItem create(Dispatch dispatch) {
        if (dispatch == null) {
            return null;
        }
        int n = dispatch.invokeGetter("Class").getInt();
        if (n == ObjectClass.APPOINTMENT.getTypeValue()) {
            return new OutlookAppointment(dispatch);
        }
        if (n == ObjectClass.CONTACT.getTypeValue()) {
            return new OutlookContact(dispatch);
        }
        if (n == ObjectClass.JOURNAL.getTypeValue()) {
            return new OutlookJournal(dispatch);
        }
        if (n == ObjectClass.MAIL.getTypeValue()) {
            return new OutlookMail(dispatch);
        }
        if (n == ObjectClass.MEETING_REQUEST.getTypeValue()) {
            return new OutlookMeeting(dispatch);
        }
        if (n == ObjectClass.MEETING_CANCELLATION.getTypeValue()) {
            return new OutlookMeeting(dispatch);
        }
        if (n == ObjectClass.MEETING_RESPONSE_NEGATIVE.getTypeValue()) {
            return new OutlookMeeting(dispatch);
        }
        if (n == ObjectClass.MEETING_RESPONSE_POSITIVE.getTypeValue()) {
            return new OutlookMeeting(dispatch);
        }
        if (n == ObjectClass.MEETING_RESPONSE_TENTATIVE.getTypeValue()) {
            return new OutlookMeeting(dispatch);
        }
        if (n == ObjectClass.NOTE.getTypeValue()) {
            return new OutlookNote(dispatch);
        }
        if (n == ObjectClass.POST.getTypeValue()) {
            return new OutlookPost(dispatch);
        }
        if (n == ObjectClass.TASK.getTypeValue()) {
            return new OutlookTask(dispatch);
        }
        if (n == ObjectClass.DOCUMENT.getTypeValue()) {
            return new OutlookDocument(dispatch);
        }
        if (n == ObjectClass.REMOTE.getTypeValue()) {
            return new OutlookRemoteItem(dispatch);
        }
        if (n == ObjectClass.REPORT.getTypeValue()) {
            return new OutlookReport(dispatch);
        }
        if (n == ObjectClass.DISTRIBUTION_LIST.getTypeValue()) {
            return new OutlookDistributionList(dispatch);
        }
        if (n == ObjectClass.TASK_REQUEST_UPDATE.getTypeValue()) {
            return new OutlookTaskRequest(dispatch);
        }
        if (n == ObjectClass.TASK_REQUEST_ACCEPT.getTypeValue()) {
            return new OutlookTaskRequest(dispatch);
        }
        if (n == ObjectClass.TASK_REQUEST_DECLINE.getTypeValue()) {
            return new OutlookTaskRequest(dispatch);
        }
        if (n == ObjectClass.TASK_REQUEST.getTypeValue()) {
            return new OutlookTaskRequest(dispatch);
        }
        return new DefaultOutlookItem(dispatch);
    }

    public OutlookItem() {
    }

    public OutlookItem(Dispatch dispatch) {
        this.mDispatch = dispatch;
    }

    public Dispatch getDispatch() {
        return this.mDispatch;
    }

    public void dispose() {
        if (this.b != null) {
            this.b.dispose();
            this.b = null;
        }
        if (this.c != null) {
            this.c.dispose();
            this.c = null;
        }
        if (this.mDispatch != null) {
            this.mDispatch.dispose();
        }
    }

    public abstract OutlookItemType getType();

    protected abstract OutlookItem createInstance(Dispatch var1);

    public OutlookItemID getItemId() throws ComponentObjectModelException {
        String string;
        if (this.a == null && (string = this.getEntryId()) != null) {
            this.a = new OutlookItemID(string);
        }
        return this.a;
    }

    private static boolean a(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof OutlookItem) {
            OutlookItem outlookItem = (OutlookItem)object;
            boolean bl = false;
            bl = true & OutlookItem.a(this.a, outlookItem.a);
            return bl;
        }
        return false;
    }

    public Date getCreationTime() {
        return this.mDispatch.invokeGetter("CreationTime").getDate();
    }

    public String getEntryId() {
        return this.mDispatch.invokeGetter("EntryID").getString();
    }

    public Date getLastModificationTime() {
        return this.mDispatch.invokeGetter("LastModificationTime").getDate();
    }

    public void delete() {
        this.mDispatch.invokeMethod("Delete");
    }

    public void display() {
        this.mDispatch.invokeMethod("Display");
    }

    public void display(boolean bl) {
        this.mDispatch.invokeMethod("Display", new Variant[]{ComUtil.createVariant(this.mDispatch, bl)});
    }

    public OutlookItem copy() {
        Dispatch dispatch = this.mDispatch.invokeMethod("Copy").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return this.createInstance(dispatch);
    }

    public OutlookItem move(OutlookFolder outlookFolder) {
        Dispatch dispatch = this.mDispatch.invokeMethod("Move", new Variant[]{ComUtil.createVariant(this.mDispatch, outlookFolder.getDispatch())}).getDispatch();
        if (dispatch == null) {
            return null;
        }
        return this.createInstance(dispatch);
    }

    public void save() {
        this.mDispatch.invokeMethod("Save");
    }

    public void saveAs(String string) {
        this.mDispatch.invokeMethod("SaveAs", new Variant[]{ComUtil.createVariant(this.mDispatch, string)});
    }

    public void saveAs(File file) {
        this.mDispatch.invokeMethod("SaveAs", new Variant[]{ComUtil.createVariant(this.mDispatch, file.getAbsolutePath())});
    }

    public void saveAs(String string, SaveAsType saveAsType) {
        this.mDispatch.invokeMethod("SaveAs", new Variant[]{ComUtil.createVariant(this.mDispatch, string), ComUtil.createVariant(this.mDispatch, saveAsType.getTypeValue())});
    }

    public void saveAs(File file, SaveAsType saveAsType) {
        this.mDispatch.invokeMethod("SaveAs", new Variant[]{ComUtil.createVariant(this.mDispatch, file.getAbsolutePath()), ComUtil.createVariant(this.mDispatch, saveAsType.getTypeValue())});
    }

    public LinksCollection getLinks() throws ComponentObjectModelException {
        Dispatch dispatch = this.mDispatch.invokeGetter("Links").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new LinksCollection(dispatch);
    }

    public OutlookFolder getParentFolder() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Parent").getDispatch();
        if (dispatch == null) {
            return null;
        }
        int n = dispatch.invokeGetter("Class").getInt();
        if (n == ObjectClass.FOLDER.getTypeValue()) {
            return new OutlookFolder(dispatch);
        }
        return null;
    }

    public void printOut() {
        this.mDispatch.invokeMethod("PrintOut");
    }

    private MapiProp a() {
        if (this.b == null) {
            this.b = Mapi.getMapiProp(this);
        }
        return this.b;
    }

    private PropertyAccessor b() {
        Dispatch dispatch;
        Variant variant;
        if (this.mDispatch.hasIdOfName("PropertyAccessor") > 0 && (variant = this.mDispatch.invokeGetter("PropertyAccessor")) != null && (dispatch = variant.getDispatch()) != null) {
            return new PropertyAccessor(dispatch);
        }
        return null;
    }

    private PropertyAccessor c() {
        if (this.d) {
            return null;
        }
        if (this.c == null) {
            this.c = this.b();
            if (this.c == null) {
                this.d = true;
            }
        }
        return this.c;
    }

    private static void a(MapiProp mapiProp, int n, int n2) {
        if (n != 0) {
            if (n2 != 0) {
                n = n & 0xFFFF0000 | n2;
            }
            mapiProp.deleteProperty(n);
        }
    }

    private static void a(MapiProp mapiProp, int n) {
        if (n != 0) {
            mapiProp.deleteProperty(n);
        }
    }

    protected void deleteProperty(int n, int n2, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.deleteProperty(string);
            return;
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return;
        }
        OutlookItem.a(mapiProp, n, n2);
    }

    protected void deleteProperty(int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.deleteProperty(string);
            return;
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return;
        }
        OutlookItem.a(mapiProp, n);
    }

    protected void deleteProperty(byte[] byArray, int n, int n2, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.deleteProperty(string);
            return;
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return;
        }
        OutlookItem.a(mapiProp, mapiProp.hasIdOfName(byArray, n), n2);
    }

    private static String b(MapiProp mapiProp, int n) {
        if (n != 0) {
            MapiPropertyValue mapiPropertyValue;
            if ((n & 0xFFFF) == 0) {
                n = n & 0xFFFF0000 | 0x1E;
            }
            if ((mapiPropertyValue = mapiProp.getProperty(n)) != null) {
                String string = mapiPropertyValue.getString();
                mapiPropertyValue.dispose();
                return string;
            }
        }
        return null;
    }

    protected String getPropertyString(int n, String string) {
        Object object;
        if (string != null && (object = this.c()) != null) {
            return (String)((PropertyAccessor)object).getProperty(string);
        }
        object = this.a();
        if (object == null) {
            return null;
        }
        return OutlookItem.b((MapiProp)object, n);
    }

    protected String getPropertyString(byte[] byArray, int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (String)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return null;
        }
        return OutlookItem.b(mapiProp, mapiProp.hasIdOfName(byArray, n));
    }

    private void a(MapiProp mapiProp, int n, String string) {
        MapiPropertyValue mapiPropertyValue = Mapi.createPropertyValue(this.mDispatch.getComManager(), string);
        if (mapiPropertyValue == null) {
            return;
        }
        mapiProp.setProperty(n, mapiPropertyValue);
        mapiPropertyValue.dispose();
    }

    protected void setPropertyString(int n, String string, String string2) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, string2);
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.a(mapiProp, n, string2);
    }

    protected void setPropertyString(byte[] byArray, int n, String string, String string2) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, string2);
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.a(mapiProp, mapiProp.getIdFromName(byArray, n), string2);
    }

    private static int b(MapiProp mapiProp, int n, int n2) {
        MapiPropertyValue mapiPropertyValue;
        if (n != 0 && (mapiPropertyValue = mapiProp.getProperty(n & 0xFFFF0000 | n2)) != null) {
            int n3 = mapiPropertyValue.getInt();
            mapiPropertyValue.dispose();
            return n3;
        }
        return 0;
    }

    protected int getPropertyInt(int n, int n2, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Integer)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return 0;
        }
        return OutlookItem.b(mapiProp, n, n2);
    }

    protected int getPropertyInt(int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Integer)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return 0;
        }
        return OutlookItem.b(mapiProp, n, 3);
    }

    protected int getPropertyInt(byte[] byArray, int n, int n2, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Integer)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return 0;
        }
        return OutlookItem.b(mapiProp, mapiProp.hasIdOfName(byArray, n), n2);
    }

    protected int getPropertyInt(byte[] byArray, int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Integer)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return 0;
        }
        return OutlookItem.b(mapiProp, mapiProp.hasIdOfName(byArray, n), 3);
    }

    private void c(MapiProp mapiProp, int n, int n2) {
        MapiPropertyValue mapiPropertyValue = Mapi.createPropertyValue(this.mDispatch.getComManager(), n2);
        if (mapiPropertyValue == null) {
            return;
        }
        mapiProp.setProperty(n, mapiPropertyValue);
    }

    protected void setPropertyInt(int n, String string, int n2) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, new Integer(n2));
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.c(mapiProp, n, n2);
    }

    protected void setPropertyInt(byte[] byArray, int n, String string, int n2) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, new Integer(n2));
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.c(mapiProp, mapiProp.getIdFromName(byArray, n), n2);
    }

    private static Date c(MapiProp mapiProp, int n) {
        MapiPropertyValue mapiPropertyValue;
        if (n != 0 && (mapiPropertyValue = mapiProp.getProperty(n & 0xFFFF0000 | 0x40)) != null) {
            Date date = mapiPropertyValue.getDate();
            mapiPropertyValue.dispose();
            return date;
        }
        return null;
    }

    protected Date getPropertyDate(int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Date)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return null;
        }
        return OutlookItem.c(mapiProp, n);
    }

    protected Date getPropertyDate(byte[] byArray, int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Date)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return null;
        }
        return OutlookItem.c(mapiProp, mapiProp.hasIdOfName(byArray, n));
    }

    private void a(MapiProp mapiProp, int n, Date date) {
        MapiPropertyValue mapiPropertyValue = Mapi.createPropertyValue(this.mDispatch.getComManager(), date);
        if (mapiPropertyValue == null) {
            return;
        }
        mapiProp.setProperty(n, mapiPropertyValue);
    }

    protected void setPropertyDate(int n, String string, Date date) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, date);
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.a(mapiProp, n, date);
    }

    protected void setPropertyDate(byte[] byArray, int n, String string, Date date) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, date);
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.a(mapiProp, mapiProp.getIdFromName(byArray, n), date);
    }

    private static double d(MapiProp mapiProp, int n) {
        MapiPropertyValue mapiPropertyValue;
        if (n != 0 && (mapiPropertyValue = mapiProp.getProperty(n & 0xFFFF0000 | 5)) != null) {
            double d2 = mapiPropertyValue.getDouble();
            mapiPropertyValue.dispose();
            return d2;
        }
        return 0.0;
    }

    protected double getPropertyDouble(int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Double)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return 0.0;
        }
        return OutlookItem.d(mapiProp, n);
    }

    protected double getPropertyDouble(byte[] byArray, int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Double)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return 0.0;
        }
        return OutlookItem.d(mapiProp, mapiProp.hasIdOfName(byArray, n));
    }

    private void a(MapiProp mapiProp, int n, double d2) {
        MapiPropertyValue mapiPropertyValue = Mapi.createPropertyValue(this.mDispatch.getComManager(), d2);
        if (mapiPropertyValue == null) {
            return;
        }
        mapiProp.setProperty(n, mapiPropertyValue);
    }

    protected void setPropertyDouble(int n, String string, double d2) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, new Double(d2));
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.a(mapiProp, n, d2);
    }

    protected void setPropertyDouble(byte[] byArray, int n, String string, double d2) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, new Double(d2));
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.a(mapiProp, mapiProp.getIdFromName(byArray, n), d2);
    }

    private static boolean e(MapiProp mapiProp, int n) {
        MapiPropertyValue mapiPropertyValue;
        if (n != 0 && (mapiPropertyValue = mapiProp.getProperty(n & 0xFFFF0000 | 0xB)) != null) {
            boolean bl = mapiPropertyValue.getBoolean();
            mapiPropertyValue.dispose();
            return bl;
        }
        return false;
    }

    protected boolean getPropertyBoolean(int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Boolean)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return false;
        }
        return OutlookItem.e(mapiProp, n);
    }

    protected boolean getPropertyBoolean(byte[] byArray, int n, String string) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            return (Boolean)propertyAccessor.getProperty(string);
        }
        MapiProp mapiProp = this.a();
        if (mapiProp == null) {
            return false;
        }
        return OutlookItem.e(mapiProp, mapiProp.hasIdOfName(byArray, n));
    }

    private void a(MapiProp mapiProp, int n, boolean bl) {
        MapiPropertyValue mapiPropertyValue = Mapi.createPropertyValue(this.mDispatch.getComManager(), bl);
        if (mapiPropertyValue == null) {
            return;
        }
        mapiProp.setProperty(n, mapiPropertyValue);
    }

    protected void setPropertyBoolean(int n, String string, boolean bl) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, new Boolean(bl));
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.a(mapiProp, n, bl);
    }

    protected void setPropertyBoolean(byte[] byArray, int n, String string, boolean bl) {
        PropertyAccessor propertyAccessor = this.c();
        if (propertyAccessor != null) {
            propertyAccessor.setProperty(string, new Boolean(bl));
            return;
        }
        MapiProp mapiProp = Mapi.getMapiProp(this);
        if (mapiProp == null) {
            return;
        }
        this.a(mapiProp, mapiProp.getIdFromName(byArray, n), bl);
    }
}

