/*
 * Decompiled with CFR 0.152.
 */
package com.moyosoft.connector.ms.outlook.task;

import com.moyosoft.connector.com.ComUtil;
import com.moyosoft.connector.com.ComponentObjectModelException;
import com.moyosoft.connector.com.Dispatch;
import com.moyosoft.connector.com.Variant;
import com.moyosoft.connector.ms.outlook.Outlook;
import com.moyosoft.connector.ms.outlook.attachment.AttachmentType;
import com.moyosoft.connector.ms.outlook.attachment.AttachmentsCollection;
import com.moyosoft.connector.ms.outlook.attachment.IAttachmentsContainer;
import com.moyosoft.connector.ms.outlook.attachment.OutlookAttachment;
import com.moyosoft.connector.ms.outlook.folder.FolderType;
import com.moyosoft.connector.ms.outlook.folder.OutlookFolder;
import com.moyosoft.connector.ms.outlook.item.ConflictsCollection;
import com.moyosoft.connector.ms.outlook.item.DownloadState;
import com.moyosoft.connector.ms.outlook.item.ImportanceType;
import com.moyosoft.connector.ms.outlook.item.ItemType;
import com.moyosoft.connector.ms.outlook.item.OutlookItem;
import com.moyosoft.connector.ms.outlook.item.OutlookItemType;
import com.moyosoft.connector.ms.outlook.item.SensitivityType;
import com.moyosoft.connector.ms.outlook.properties.ItemPropertiesCollection;
import com.moyosoft.connector.ms.outlook.properties.UserPropertiesCollection;
import com.moyosoft.connector.ms.outlook.recipient.RecipientsCollection;
import com.moyosoft.connector.ms.outlook.recurrence.RecurrencePattern;
import com.moyosoft.connector.ms.outlook.remote.RemoteStatus;
import com.moyosoft.connector.ms.outlook.task.TaskDelegationState;
import com.moyosoft.connector.ms.outlook.task.TaskOwnership;
import com.moyosoft.connector.ms.outlook.task.TaskResponseType;
import com.moyosoft.connector.ms.outlook.task.TaskStatus;
import com.moyosoft.connector.ms.outlook.ui.FormDescription;
import com.moyosoft.connector.ms.outlook.ui.Inspector;
import com.moyosoft.connector.ms.outlook.ui.InspectorClose;
import java.io.File;
import java.util.Date;

public class OutlookTask
extends OutlookItem
implements IAttachmentsContainer {
    public OutlookTask(OutlookFolder outlookFolder) throws ComponentObjectModelException {
        this.mDispatch = outlookFolder.createItem(ItemType.TASK).getDispatch();
    }

    public OutlookTask(Outlook outlook) throws ComponentObjectModelException {
        this.mDispatch = outlook.getDefaultFolder(FolderType.TASKS).createItem(ItemType.TASK).getDispatch();
    }

    public OutlookTask(Dispatch dispatch) {
        super(dispatch);
    }

    public OutlookItemType getType() {
        return OutlookItemType.TASK;
    }

    protected OutlookItem createInstance(Dispatch dispatch) {
        return new OutlookTask(dispatch);
    }

    public AttachmentsCollection getAttachments() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Attachments").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new AttachmentsCollection(dispatch);
    }

    public OutlookAttachment createAttachment(File file, AttachmentType attachmentType) {
        return this.getAttachments().add(file, attachmentType);
    }

    public int getAttachmentsCount() {
        return this.getAttachments().getCount();
    }

    public String getBillingInformation() {
        return this.mDispatch.invokeGetter("BillingInformation").getString();
    }

    public void setBillingInformation(String string) {
        this.mDispatch.invokeSetter("BillingInformation", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getBody() {
        return this.mDispatch.invokeGetter("Body").getString();
    }

    public void setBody(String string) {
        this.mDispatch.invokeSetter("Body", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCategories() {
        return this.mDispatch.invokeGetter("Categories").getString();
    }

    public void setCategories(String string) {
        this.mDispatch.invokeSetter("Categories", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getCompanies() {
        return this.mDispatch.invokeGetter("Companies").getString();
    }

    public void setCompanies(String string) {
        this.mDispatch.invokeSetter("Companies", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getConversationIndex() {
        return this.mDispatch.invokeGetter("ConversationIndex").getString();
    }

    public String getConversationTopic() {
        return this.mDispatch.invokeGetter("ConversationTopic").getString();
    }

    public FormDescription getFormDescription() {
        Dispatch dispatch = this.mDispatch.invokeGetter("FormDescription").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new FormDescription(dispatch);
    }

    public Inspector getInspector() {
        Dispatch dispatch = this.mDispatch.invokeGetter("GetInspector").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new Inspector(dispatch);
    }

    public ImportanceType getImportance() {
        return ImportanceType.getById(this.mDispatch.invokeGetter("Importance").getAsInt());
    }

    public void setImportance(ImportanceType importanceType) {
        this.mDispatch.invokeSetter("Importance", ComUtil.createVariant(this.mDispatch, importanceType.getTypeValue()));
    }

    public String getMessageClass() {
        return this.mDispatch.invokeGetter("MessageClass").getString();
    }

    public void setMessageClass(String string) {
        this.mDispatch.invokeSetter("MessageClass", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getMileage() {
        return this.mDispatch.invokeGetter("Mileage").getString();
    }

    public void setMileage(String string) {
        this.mDispatch.invokeSetter("Mileage", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isNoAging() {
        return this.mDispatch.invokeGetter("NoAging").getBoolean();
    }

    public void setNoAging(boolean bl) {
        this.mDispatch.invokeSetter("NoAging", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isSaved() {
        return this.mDispatch.invokeGetter("Saved").getBoolean();
    }

    public SensitivityType getSensitivity() {
        return SensitivityType.getById(this.mDispatch.invokeGetter("Sensitivity").getAsInt());
    }

    public void setSensitivity(SensitivityType sensitivityType) {
        this.mDispatch.invokeSetter("Sensitivity", ComUtil.createVariant(this.mDispatch, sensitivityType.getTypeValue()));
    }

    public int getSize() {
        return this.mDispatch.invokeGetter("Size").getInt();
    }

    public String getSubject() {
        return this.mDispatch.invokeGetter("Subject").getString();
    }

    public void setSubject(String string) {
        this.mDispatch.invokeSetter("Subject", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isUnRead() {
        return this.mDispatch.invokeGetter("UnRead").getBoolean();
    }

    public void setUnRead(boolean bl) {
        this.mDispatch.invokeSetter("UnRead", ComUtil.createVariant(this.mDispatch, bl));
    }

    public UserPropertiesCollection getUserProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("UserProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new UserPropertiesCollection(dispatch);
    }

    public void close(InspectorClose inspectorClose) {
        this.mDispatch.invokeMethod("Close", new Variant[]{ComUtil.createVariant(this.mDispatch, inspectorClose.getTypeValue())});
    }

    public int getActualWork() {
        return this.mDispatch.invokeGetter("ActualWork").getInt();
    }

    public void setActualWork(int n) {
        this.mDispatch.invokeSetter("ActualWork", ComUtil.createVariant(this.mDispatch, n));
    }

    public String getCardData() {
        return this.mDispatch.invokeGetter("CardData").getString();
    }

    public void setCardData(String string) {
        this.mDispatch.invokeSetter("CardData", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isComplete() {
        return this.mDispatch.invokeGetter("Complete").getBoolean();
    }

    public void setComplete(boolean bl) {
        this.mDispatch.invokeSetter("Complete", ComUtil.createVariant(this.mDispatch, bl));
    }

    public String getContacts() {
        return this.mDispatch.invokeGetter("Contacts").getString();
    }

    public void setContacts(String string) {
        this.mDispatch.invokeSetter("Contacts", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getContactNames() {
        return this.mDispatch.invokeGetter("ContactNames").getString();
    }

    public void setContactNames(String string) {
        this.mDispatch.invokeSetter("ContactNames", ComUtil.createVariant(this.mDispatch, string));
    }

    public Date getDateCompleted() {
        return this.mDispatch.invokeGetter("DateCompleted").getDate();
    }

    public void setDateCompleted(Date date) {
        this.mDispatch.invokeSetter("DateCompleted", ComUtil.createVariant(this.mDispatch, date));
    }

    public TaskDelegationState getDelegationState() {
        return TaskDelegationState.getById(this.mDispatch.invokeGetter("DelegationState").getAsInt());
    }

    public String getDelegator() {
        return this.mDispatch.invokeGetter("Delegator").getString();
    }

    public Date getDueDate() {
        return this.mDispatch.invokeGetter("DueDate").getDate();
    }

    public void setDueDate(Date date) {
        this.mDispatch.invokeSetter("DueDate", ComUtil.createVariant(this.mDispatch, date));
    }

    public boolean isRecurring() {
        return this.mDispatch.invokeGetter("IsRecurring").getBoolean();
    }

    public int getOrdinal() {
        return this.mDispatch.invokeGetter("Ordinal").getInt();
    }

    public void setOrdinal(int n) {
        this.mDispatch.invokeSetter("Ordinal", ComUtil.createVariant(this.mDispatch, n));
    }

    public String getOwner() {
        return this.mDispatch.invokeGetter("Owner").getString();
    }

    public void setOwner(String string) {
        this.mDispatch.invokeSetter("Owner", ComUtil.createVariant(this.mDispatch, string));
    }

    public TaskOwnership getOwnership() {
        return TaskOwnership.getById(this.mDispatch.invokeGetter("Ownership").getAsInt());
    }

    public int getPercentComplete() {
        return this.mDispatch.invokeGetter("PercentComplete").getInt();
    }

    public void setPercentComplete(int n) {
        this.mDispatch.invokeSetter("PercentComplete", ComUtil.createVariant(this.mDispatch, n));
    }

    public RecipientsCollection getRecipients() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Recipients").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new RecipientsCollection(OutlookItemType.TASK, dispatch);
    }

    public Date getReminderTime() {
        return this.mDispatch.invokeGetter("ReminderTime").getDate();
    }

    public void setReminderTime(Date date) {
        this.mDispatch.invokeSetter("ReminderTime", ComUtil.createVariant(this.mDispatch, date));
    }

    public boolean isReminderOverrideDefault() {
        return this.mDispatch.invokeGetter("ReminderOverrideDefault").getBoolean();
    }

    public void setReminderOverrideDefault(boolean bl) {
        this.mDispatch.invokeSetter("ReminderOverrideDefault", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isReminderPlaySound() {
        return this.mDispatch.invokeGetter("ReminderPlaySound").getBoolean();
    }

    public void setReminderPlaySound(boolean bl) {
        this.mDispatch.invokeSetter("ReminderPlaySound", ComUtil.createVariant(this.mDispatch, bl));
    }

    public boolean isReminderSet() {
        return this.mDispatch.invokeGetter("ReminderSet").getBoolean();
    }

    public void setReminderSet(boolean bl) {
        this.mDispatch.invokeSetter("ReminderSet", ComUtil.createVariant(this.mDispatch, bl));
    }

    public String getReminderSoundFile() {
        return this.mDispatch.invokeGetter("ReminderSoundFile").getString();
    }

    public void setReminderSoundFile(String string) {
        this.mDispatch.invokeSetter("ReminderSoundFile", ComUtil.createVariant(this.mDispatch, string));
    }

    public TaskResponseType getResponseState() {
        return TaskResponseType.getById(this.mDispatch.invokeGetter("ResponseState").getAsInt());
    }

    public String getRole() {
        return this.mDispatch.invokeGetter("Role").getString();
    }

    public void setRole(String string) {
        this.mDispatch.invokeSetter("Role", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getSchedulePlusPriority() {
        return this.mDispatch.invokeGetter("SchedulePlusPriority").getString();
    }

    public void setSchedulePlusPriority(String string) {
        this.mDispatch.invokeSetter("SchedulePlusPriority", ComUtil.createVariant(this.mDispatch, string));
    }

    public Date getStartDate() {
        return this.mDispatch.invokeGetter("StartDate").getDate();
    }

    public void setStartDate(Date date) {
        this.mDispatch.invokeSetter("StartDate", ComUtil.createVariant(this.mDispatch, date));
    }

    public TaskStatus getStatus() {
        return TaskStatus.getById(this.mDispatch.invokeGetter("Status").getAsInt());
    }

    public void setStatus(TaskStatus taskStatus) {
        this.mDispatch.invokeSetter("Status", ComUtil.createVariant(this.mDispatch, taskStatus.getTypeValue()));
    }

    public String getStatusOnCompletionRecipients() {
        return this.mDispatch.invokeGetter("StatusOnCompletionRecipients").getString();
    }

    public void setStatusOnCompletionRecipients(String string) {
        this.mDispatch.invokeSetter("StatusOnCompletionRecipients", ComUtil.createVariant(this.mDispatch, string));
    }

    public String getStatusUpdateRecipients() {
        return this.mDispatch.invokeGetter("StatusUpdateRecipients").getString();
    }

    public void setStatusUpdateRecipients(String string) {
        this.mDispatch.invokeSetter("StatusUpdateRecipients", ComUtil.createVariant(this.mDispatch, string));
    }

    public boolean isTeamTask() {
        return this.mDispatch.invokeGetter("TeamTask").getBoolean();
    }

    public void setTeamTask(boolean bl) {
        this.mDispatch.invokeSetter("TeamTask", ComUtil.createVariant(this.mDispatch, bl));
    }

    public int getTotalWork() {
        return this.mDispatch.invokeGetter("TotalWork").getInt();
    }

    public void setTotalWork(int n) {
        this.mDispatch.invokeSetter("TotalWork", ComUtil.createVariant(this.mDispatch, n));
    }

    public OutlookTask assign() {
        Dispatch dispatch = this.mDispatch.invokeMethod("Assign").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookTask(dispatch);
    }

    public void cancelResponseState() {
        this.mDispatch.invokeMethod("CancelResponseState");
    }

    public void clearRecurrencePattern() {
        this.mDispatch.invokeMethod("ClearRecurrencePattern");
    }

    public RecurrencePattern getRecurrencePattern() {
        Dispatch dispatch = this.mDispatch.invokeMethod("GetRecurrencePattern").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new RecurrencePattern(dispatch);
    }

    public void markComplete() {
        this.mDispatch.invokeMethod("MarkComplete");
    }

    public OutlookTask respond(TaskResponseType taskResponseType, boolean bl, boolean bl2) {
        Dispatch dispatch = this.mDispatch.invokeMethod("Respond", new Variant[]{ComUtil.createVariant(this.mDispatch, taskResponseType.getTypeValue()), ComUtil.createVariant(this.mDispatch, bl), ComUtil.createVariant(this.mDispatch, bl2)}).getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new OutlookTask(dispatch);
    }

    public void send() {
        this.mDispatch.invokeMethod("Send");
    }

    public boolean skipRecurrence() {
        return this.mDispatch.invokeMethod("SkipRecurrence").getBoolean();
    }

    public DownloadState getDownloadState() {
        return DownloadState.getById(this.mDispatch.invokeGetter("DownloadState").getAsInt());
    }

    public void showCategoriesDialog() {
        this.mDispatch.invokeMethod("ShowCategoriesDialog");
    }

    public ItemPropertiesCollection getItemProperties() {
        Dispatch dispatch = this.mDispatch.invokeGetter("ItemProperties").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ItemPropertiesCollection(dispatch);
    }

    public int getInternetCodepage() {
        return this.mDispatch.invokeGetter("InternetCodepage").getInt();
    }

    public void setInternetCodepage(int n) {
        this.mDispatch.invokeSetter("InternetCodepage", ComUtil.createVariant(this.mDispatch, n));
    }

    public RemoteStatus getMarkForDownload() {
        return RemoteStatus.getById(this.mDispatch.invokeGetter("MarkForDownload").getAsInt());
    }

    public void setMarkForDownload(RemoteStatus remoteStatus) {
        this.mDispatch.invokeSetter("MarkForDownload", ComUtil.createVariant(this.mDispatch, remoteStatus.getTypeValue()));
    }

    public boolean isConflict() {
        return this.mDispatch.invokeGetter("IsConflict").getBoolean();
    }

    public boolean isAutoResolvedWinner() {
        return this.mDispatch.invokeGetter("AutoResolvedWinner").getBoolean();
    }

    public ConflictsCollection getConflicts() {
        Dispatch dispatch = this.mDispatch.invokeGetter("Conflicts").getDispatch();
        if (dispatch == null) {
            return null;
        }
        return new ConflictsCollection(dispatch);
    }
}

