/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.algorithm.IntegerEncodingAlgorithm;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class LongEncodingAlgorithm
extends IntegerEncodingAlgorithm {
    @Override
    public int getPrimtiveLengthFromOctetLength(int octetLength) throws EncodingAlgorithmException {
        if (octetLength % 8 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfLong", new Object[]{8}));
        }
        return octetLength / 8;
    }

    @Override
    public int getOctetLengthFromPrimitiveLength(int primitiveLength) {
        return primitiveLength * 8;
    }

    @Override
    public final Object decodeFromBytes(byte[] b2, int start, int length) throws EncodingAlgorithmException {
        long[] data = new long[this.getPrimtiveLengthFromOctetLength(length)];
        this.decodeFromBytesToLongArray(data, 0, b2, start, length);
        return data;
    }

    @Override
    public final Object decodeFromInputStream(InputStream s) throws IOException {
        return this.decodeFromInputStreamToIntArray(s);
    }

    @Override
    public void encodeToOutputStream(Object data, OutputStream s) throws IOException {
        if (!(data instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] ldata = (long[])data;
        this.encodeToOutputStreamFromLongArray(ldata, s);
    }

    @Override
    public Object convertFromCharacters(char[] ch, int start, int length) {
        CharBuffer cb = CharBuffer.wrap(ch, start, length);
        ArrayList<Long> longList = new ArrayList<Long>();
        this.matchWhiteSpaceDelimnatedWords(cb, (start1, end) -> {
            String lStringValue = cb.subSequence(start1, end).toString();
            longList.add(Long.valueOf(lStringValue));
        });
        return this.generateArrayFromList(longList);
    }

    @Override
    public void convertToCharacters(Object data, StringBuffer s) {
        if (!(data instanceof long[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotLongArray"));
        }
        long[] ldata = (long[])data;
        this.convertToCharactersFromLongArray(ldata, s);
    }

    public final void decodeFromBytesToLongArray(long[] ldata, int istart, byte[] b2, int start, int length) {
        int size = length / 8;
        for (int i2 = 0; i2 < size; ++i2) {
            ldata[istart++] = (long)(b2[start++] & 0xFF) << 56 | (long)(b2[start++] & 0xFF) << 48 | (long)(b2[start++] & 0xFF) << 40 | (long)(b2[start++] & 0xFF) << 32 | (long)(b2[start++] & 0xFF) << 24 | (long)(b2[start++] & 0xFF) << 16 | (long)(b2[start++] & 0xFF) << 8 | (long)(b2[start++] & 0xFF);
        }
    }

    public final long[] decodeFromInputStreamToIntArray(InputStream s) throws IOException {
        ArrayList<Long> longList = new ArrayList<Long>();
        byte[] b2 = new byte[8];
        while (true) {
            int n;
            if ((n = s.read(b2)) != 8) {
                if (n == -1) break;
                while (n != 8) {
                    int m2 = s.read(b2, n, 8 - n);
                    if (m2 == -1) {
                        throw new EOFException();
                    }
                    n += m2;
                }
            }
            long l2 = ((long)b2[0] << 56) + ((long)(b2[1] & 0xFF) << 48) + ((long)(b2[2] & 0xFF) << 40) + ((long)(b2[3] & 0xFF) << 32) + ((long)(b2[4] & 0xFF) << 24) + (long)((b2[5] & 0xFF) << 16) + (long)((b2[6] & 0xFF) << 8) + (long)(b2[7] & 0xFF);
            longList.add(l2);
        }
        return this.generateArrayFromList(longList);
    }

    public final void encodeToOutputStreamFromLongArray(long[] ldata, OutputStream s) throws IOException {
        for (int i2 = 0; i2 < ldata.length; ++i2) {
            long bits = ldata[i2];
            s.write((int)(bits >>> 56 & 0xFFL));
            s.write((int)(bits >>> 48 & 0xFFL));
            s.write((int)(bits >>> 40 & 0xFFL));
            s.write((int)(bits >>> 32 & 0xFFL));
            s.write((int)(bits >>> 24 & 0xFFL));
            s.write((int)(bits >>> 16 & 0xFFL));
            s.write((int)(bits >>> 8 & 0xFFL));
            s.write((int)(bits & 0xFFL));
        }
    }

    @Override
    public final void encodeToBytes(Object array, int astart, int alength, byte[] b2, int start) {
        this.encodeToBytesFromLongArray((long[])array, astart, alength, b2, start);
    }

    public final void encodeToBytesFromLongArray(long[] ldata, int lstart, int llength, byte[] b2, int start) {
        int lend = lstart + llength;
        for (int i2 = lstart; i2 < lend; ++i2) {
            long bits = ldata[i2];
            b2[start++] = (byte)(bits >>> 56 & 0xFFL);
            b2[start++] = (byte)(bits >>> 48 & 0xFFL);
            b2[start++] = (byte)(bits >>> 40 & 0xFFL);
            b2[start++] = (byte)(bits >>> 32 & 0xFFL);
            b2[start++] = (byte)(bits >>> 24 & 0xFFL);
            b2[start++] = (byte)(bits >>> 16 & 0xFFL);
            b2[start++] = (byte)(bits >>> 8 & 0xFFL);
            b2[start++] = (byte)(bits & 0xFFL);
        }
    }

    public final void convertToCharactersFromLongArray(long[] ldata, StringBuffer s) {
        int end = ldata.length - 1;
        for (int i2 = 0; i2 <= end; ++i2) {
            s.append(Long.toString(ldata[i2]));
            if (i2 == end) continue;
            s.append(' ');
        }
    }

    public final long[] generateArrayFromList(List<Long> array) {
        long[] ldata = new long[array.size()];
        for (int i2 = 0; i2 < ldata.length; ++i2) {
            ldata[i2] = array.get(i2);
        }
        return ldata;
    }
}

