/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.util;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import jakarta.xml.soap.SOAPException;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class RejectDoctypeSaxFilter
extends XMLFilterImpl
implements XMLReader,
LexicalHandler {
    private static final Logger log = Logger.getLogger("com.sun.xml.messaging.saaj.util", "com.sun.xml.messaging.saaj.util.LocalStrings");
    static final String LEXICAL_HANDLER_PROP = "http://xml.org/sax/properties/lexical-handler";
    static final String WSU_NS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    static final String SIGNATURE_LNAME = "Signature";
    static final String ENCRYPTED_DATA_LNAME = "EncryptedData";
    static final String DSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    static final String XENC_NS = "http://www.w3.org/2001/04/xmlenc#";
    static final String ID_NAME = "ID";
    private LexicalHandler lexicalHandler;

    public RejectDoctypeSaxFilter(SAXParser saxParser) throws SOAPException {
        XMLReader xmlReader;
        try {
            xmlReader = saxParser.getXMLReader();
        }
        catch (SAXException e2) {
            log.severe("SAAJ0602.util.getXMLReader.exception");
            throw new SOAPExceptionImpl("Couldn't get an XMLReader while constructing a RejectDoctypeSaxFilter", e2);
        }
        try {
            xmlReader.setProperty(LEXICAL_HANDLER_PROP, this);
        }
        catch (Exception e3) {
            log.severe("SAAJ0603.util.setProperty.exception");
            throw new SOAPExceptionImpl("Couldn't set the lexical handler property while constructing a RejectDoctypeSaxFilter", e3);
        }
        this.setParent(xmlReader);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (LEXICAL_HANDLER_PROP.equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        throw new SAXException("Document Type Declaration is not allowed");
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (atts != null) {
            boolean eos = false;
            if (namespaceURI == DSIG_NS || XENC_NS == namespaceURI) {
                eos = true;
            }
            int length = atts.getLength();
            AttributesImpl attrImpl = new AttributesImpl();
            for (int i2 = 0; i2 < length; ++i2) {
                String name = atts.getLocalName(i2);
                if (name != null && name.equals("Id")) {
                    if (eos || atts.getURI(i2) == WSU_NS) {
                        attrImpl.addAttribute(atts.getURI(i2), atts.getLocalName(i2), atts.getQName(i2), ID_NAME, atts.getValue(i2));
                        continue;
                    }
                    attrImpl.addAttribute(atts.getURI(i2), atts.getLocalName(i2), atts.getQName(i2), atts.getType(i2), atts.getValue(i2));
                    continue;
                }
                attrImpl.addAttribute(atts.getURI(i2), atts.getLocalName(i2), atts.getQName(i2), atts.getType(i2), atts.getValue(i2));
            }
            super.startElement(namespaceURI, localName, qName, attrImpl);
        } else {
            super.startElement(namespaceURI, localName, qName, null);
        }
    }
}

