/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.handler.HandlerTube;
import com.sun.xml.ws.handler.MessageUpdatableContext;
import jakarta.xml.ws.ProtocolException;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class HandlerProcessor<C extends MessageUpdatableContext> {
    boolean isClient;
    static final Logger logger = Logger.getLogger("com.sun.xml.ws.handler");
    private List<? extends Handler> handlers;
    WSBinding binding;
    private int index = -1;
    private HandlerTube owner;

    protected HandlerProcessor(HandlerTube owner, WSBinding binding, List<? extends Handler> chain) {
        this.owner = owner;
        if (chain == null) {
            chain = new ArrayList<Handler>();
        }
        this.handlers = chain;
        this.binding = binding;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int i2) {
        this.index = i2;
    }

    public boolean callHandlersRequest(Direction direction, C context, boolean responseExpected) {
        boolean result;
        this.setDirection(direction, context);
        try {
            result = direction == Direction.OUTBOUND ? this.callHandleMessage(context, 0, this.handlers.size() - 1) : this.callHandleMessage(context, this.handlers.size() - 1, 0);
        }
        catch (ProtocolException pe) {
            logger.log(Level.FINER, "exception in handler chain", pe);
            if (responseExpected) {
                this.insertFaultMessage(context, pe);
                this.reverseDirection(direction, context);
                this.setHandleFaultProperty();
                if (direction == Direction.OUTBOUND) {
                    this.callHandleFault(context, this.getIndex() - 1, 0);
                } else {
                    this.callHandleFault(context, this.getIndex() + 1, this.handlers.size() - 1);
                }
                return false;
            }
            throw pe;
        }
        catch (RuntimeException re) {
            logger.log(Level.FINER, "exception in handler chain", re);
            throw re;
        }
        if (!result) {
            if (responseExpected) {
                this.reverseDirection(direction, context);
                if (direction == Direction.OUTBOUND) {
                    this.callHandleMessageReverse(context, this.getIndex() - 1, 0);
                } else {
                    this.callHandleMessageReverse(context, this.getIndex() + 1, this.handlers.size() - 1);
                }
            } else {
                this.setHandleFalseProperty();
            }
            return false;
        }
        return result;
    }

    public void callHandlersResponse(Direction direction, C context, boolean isFault) {
        this.setDirection(direction, context);
        try {
            if (isFault) {
                if (direction == Direction.OUTBOUND) {
                    this.callHandleFault(context, 0, this.handlers.size() - 1);
                } else {
                    this.callHandleFault(context, this.handlers.size() - 1, 0);
                }
            } else if (direction == Direction.OUTBOUND) {
                this.callHandleMessageReverse(context, 0, this.handlers.size() - 1);
            } else {
                this.callHandleMessageReverse(context, this.handlers.size() - 1, 0);
            }
        }
        catch (RuntimeException re) {
            logger.log(Level.FINER, "exception in handler chain", re);
            throw re;
        }
    }

    private void reverseDirection(Direction origDirection, C context) {
        if (origDirection == Direction.OUTBOUND) {
            ((MessageUpdatableContext)context).put("jakarta.xml.ws.handler.message.outbound", (Object)false);
        } else {
            ((MessageUpdatableContext)context).put("jakarta.xml.ws.handler.message.outbound", (Object)true);
        }
    }

    private void setDirection(Direction direction, C context) {
        if (direction == Direction.OUTBOUND) {
            ((MessageUpdatableContext)context).put("jakarta.xml.ws.handler.message.outbound", (Object)true);
        } else {
            ((MessageUpdatableContext)context).put("jakarta.xml.ws.handler.message.outbound", (Object)false);
        }
    }

    private void setHandleFaultProperty() {
        this.owner.setHandleFault();
    }

    private void setHandleFalseProperty() {
        this.owner.setHandleFalse();
    }

    abstract void insertFaultMessage(C var1, ProtocolException var2);

    private boolean callHandleMessage(C context, int start, int end) {
        int i2;
        try {
            if (start > end) {
                for (i2 = start; i2 >= end; --i2) {
                    if (this.handlers.get(i2).handleMessage(context)) continue;
                    this.setIndex(i2);
                    return false;
                }
            } else {
                while (i2 <= end) {
                    if (!this.handlers.get(i2).handleMessage(context)) {
                        this.setIndex(i2);
                        return false;
                    }
                    ++i2;
                }
            }
        }
        catch (RuntimeException e2) {
            this.setIndex(i2);
            throw e2;
        }
        return true;
    }

    private boolean callHandleMessageReverse(C context, int start, int end) {
        int i2;
        if (this.handlers.isEmpty() || start == -1 || start == this.handlers.size()) {
            return false;
        }
        if (start > end) {
            for (i2 = start; i2 >= end; --i2) {
                if (this.handlers.get(i2).handleMessage(context)) continue;
                this.setHandleFalseProperty();
                return false;
            }
        } else {
            while (i2 <= end) {
                if (!this.handlers.get(i2).handleMessage(context)) {
                    this.setHandleFalseProperty();
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    private boolean callHandleFault(C context, int start, int end) {
        int i2;
        if (this.handlers.isEmpty() || start == -1 || start == this.handlers.size()) {
            return false;
        }
        if (start > end) {
            try {
                for (i2 = start; i2 >= end; --i2) {
                    if (this.handlers.get(i2).handleFault(context)) continue;
                    return false;
                }
            }
            catch (RuntimeException re) {
                logger.log(Level.FINER, "exception in handler chain", re);
                throw re;
            }
        }
        try {
            while (i2 <= end) {
                if (!this.handlers.get(i2).handleFault(context)) {
                    return false;
                }
                ++i2;
            }
        }
        catch (RuntimeException re) {
            logger.log(Level.FINER, "exception in handler chain", re);
            throw re;
        }
        return true;
    }

    void closeHandlers(MessageContext context, int start, int end) {
        if (this.handlers.isEmpty() || start == -1) {
            return;
        }
        if (start > end) {
            for (int i2 = start; i2 >= end; --i2) {
                try {
                    this.handlers.get(i2).close(context);
                    continue;
                }
                catch (RuntimeException re) {
                    logger.log(Level.INFO, "Exception ignored during close", re);
                }
            }
        } else {
            for (int i3 = start; i3 <= end; ++i3) {
                try {
                    this.handlers.get(i3).close(context);
                    continue;
                }
                catch (RuntimeException re) {
                    logger.log(Level.INFO, "Exception ignored during close", re);
                }
            }
        }
    }

    public static enum Direction {
        OUTBOUND,
        INBOUND;

    }

    public static enum RequestOrResponse {
        REQUEST,
        RESPONSE;

    }
}

