/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.message;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.message.AbstractHeaderImpl;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class ProblemActionHeader
extends AbstractHeaderImpl {
    @NotNull
    protected String action;
    protected String soapAction;
    @NotNull
    protected AddressingVersion av;
    private static final String actionLocalName = "Action";
    private static final String soapActionLocalName = "SoapAction";

    public ProblemActionHeader(@NotNull String action, @NotNull AddressingVersion av) {
        this(action, null, av);
    }

    public ProblemActionHeader(@NotNull String action, String soapAction, @NotNull AddressingVersion av) {
        assert (action != null);
        assert (av != null);
        this.action = action;
        this.soapAction = soapAction;
        this.av = av;
    }

    @Override
    @NotNull
    public String getNamespaceURI() {
        return this.av.nsUri;
    }

    @Override
    @NotNull
    public String getLocalPart() {
        return "ProblemAction";
    }

    @Override
    @Nullable
    public String getAttribute(@NotNull String nsUri, @NotNull String localName) {
        return null;
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        MutableXMLStreamBuffer buf = new MutableXMLStreamBuffer();
        XMLStreamWriter w = buf.createFromXMLStreamWriter();
        this.writeTo(w);
        return buf.readAsXMLStreamReader();
    }

    @Override
    public void writeTo(XMLStreamWriter w) throws XMLStreamException {
        w.writeStartElement("", this.getLocalPart(), this.getNamespaceURI());
        w.writeDefaultNamespace(this.getNamespaceURI());
        w.writeStartElement(actionLocalName);
        w.writeCharacters(this.action);
        w.writeEndElement();
        if (this.soapAction != null) {
            w.writeStartElement(soapActionLocalName);
            w.writeCharacters(this.soapAction);
            w.writeEndElement();
        }
        w.writeEndElement();
    }

    @Override
    public void writeTo(SOAPMessage saaj) throws SOAPException {
        SOAPHeader header = saaj.getSOAPHeader();
        if (header == null) {
            header = saaj.getSOAPPart().getEnvelope().addHeader();
        }
        SOAPHeaderElement she = header.addHeaderElement(new QName(this.getNamespaceURI(), this.getLocalPart()));
        she.addChildElement(actionLocalName);
        she.addTextNode(this.action);
        if (this.soapAction != null) {
            she.addChildElement(soapActionLocalName);
            she.addTextNode(this.soapAction);
        }
    }

    @Override
    public void writeTo(ContentHandler h2, ErrorHandler errorHandler) throws SAXException {
        String nsUri = this.getNamespaceURI();
        String ln = this.getLocalPart();
        h2.startPrefixMapping("", nsUri);
        h2.startElement(nsUri, ln, ln, EMPTY_ATTS);
        h2.startElement(nsUri, actionLocalName, actionLocalName, EMPTY_ATTS);
        h2.characters(this.action.toCharArray(), 0, this.action.length());
        h2.endElement(nsUri, actionLocalName, actionLocalName);
        if (this.soapAction != null) {
            h2.startElement(nsUri, soapActionLocalName, soapActionLocalName, EMPTY_ATTS);
            h2.characters(this.soapAction.toCharArray(), 0, this.soapAction.length());
            h2.endElement(nsUri, soapActionLocalName, soapActionLocalName);
        }
        h2.endElement(nsUri, ln, ln);
    }
}

