/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.ws.server.provider.ProviderEndpointModel;
import jakarta.activation.DataSource;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.http.HTTPException;
import javax.xml.transform.Source;

abstract class XMLProviderArgumentBuilder<T>
extends ProviderArgumentsBuilder<T> {
    XMLProviderArgumentBuilder() {
    }

    @Override
    protected Packet getResponse(Packet request, Exception e2, WSDLPort port, WSBinding binding) {
        Packet response = super.getResponse(request, e2, port, binding);
        if (e2 instanceof HTTPException && response.supports("jakarta.xml.ws.http.response.code")) {
            response.put("jakarta.xml.ws.http.response.code", ((HTTPException)e2).getStatusCode());
        }
        return response;
    }

    static XMLProviderArgumentBuilder createBuilder(ProviderEndpointModel model, WSBinding binding) {
        if (model.mode == Service.Mode.PAYLOAD) {
            return new PayloadSource();
        }
        if (model.datatype == Source.class) {
            return new PayloadSource();
        }
        if (model.datatype == DataSource.class) {
            return new DataSourceParameter(binding);
        }
        throw new WebServiceException(ServerMessages.PROVIDER_INVALID_PARAMETER_TYPE(model.implClass, model.datatype));
    }

    private static final class PayloadSource
    extends XMLProviderArgumentBuilder<Source> {
        private PayloadSource() {
        }

        @Override
        public Source getParameter(Packet packet) {
            return packet.getMessage().readPayloadAsSource();
        }

        @Override
        public Message getResponseMessage(Source source) {
            return Messages.createUsingPayload(source, SOAPVersion.SOAP_11);
        }

        @Override
        protected Message getResponseMessage(Exception e2) {
            return XMLMessage.create(e2);
        }
    }

    private static final class DataSourceParameter
    extends XMLProviderArgumentBuilder<DataSource> {
        private final WSBinding binding;

        DataSourceParameter(WSBinding binding) {
            this.binding = binding;
        }

        @Override
        public DataSource getParameter(Packet packet) {
            Message msg = packet.getInternalMessage();
            return msg instanceof XMLMessage.MessageDataSource ? ((XMLMessage.MessageDataSource)((Object)msg)).getDataSource() : XMLMessage.getDataSource(msg, this.binding.getFeatures());
        }

        @Override
        public Message getResponseMessage(DataSource ds) {
            return XMLMessage.create(ds, this.binding.getFeatures());
        }

        @Override
        protected Message getResponseMessage(Exception e2) {
            return XMLMessage.create(e2);
        }
    }
}

