/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASCIIUtility {
    private ASCIIUtility() {
    }

    public static int parseInt(byte[] b2, int start, int end, int radix) throws NumberFormatException {
        if (b2 == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i2 = start;
        if (end > start) {
            int digit;
            int limit;
            if (b2[i2] == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i2;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i2 < end) {
                if ((digit = Character.digit((char)b2[i2++], radix)) < 0) {
                    throw new NumberFormatException("illegal number: " + ASCIIUtility.toString(b2, start, end));
                }
                result = -digit;
            }
            while (i2 < end) {
                if ((digit = Character.digit((char)b2[i2++], radix)) < 0) {
                    throw new NumberFormatException("illegal number");
                }
                if (result < multmin) {
                    throw new NumberFormatException("illegal number");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("illegal number");
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("illegal number");
        }
        if (negative) {
            if (i2 > start + 1) {
                return result;
            }
            throw new NumberFormatException("illegal number");
        }
        return -result;
    }

    public static String toString(byte[] b2, int start, int end) {
        int size = end - start;
        char[] theChars = new char[size];
        int i2 = 0;
        int j2 = start;
        while (i2 < size) {
            theChars[i2++] = (char)(b2[j2++] & 0xFF);
        }
        return new String(theChars);
    }

    public static void copyStream(InputStream is, OutputStream out) throws IOException {
        int len;
        int size = 1024;
        byte[] buf = new byte[size];
        while ((len = is.read(buf, 0, size)) != -1) {
            out.write(buf, 0, len);
        }
    }
}

