/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util;

import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Pool<T> {
    private volatile SoftReference<ConcurrentLinkedQueue<T>> queue;

    protected Pool() {
    }

    public final T take() {
        T t = this.getQueue().poll();
        if (t == null) {
            return this.create();
        }
        return t;
    }

    private ConcurrentLinkedQueue<T> getQueue() {
        ConcurrentLinkedQueue<Object> d2;
        SoftReference<ConcurrentLinkedQueue<T>> q = this.queue;
        if (q != null && (d2 = q.get()) != null) {
            return d2;
        }
        d2 = new ConcurrentLinkedQueue();
        this.queue = new SoftReference<ConcurrentLinkedQueue<ConcurrentLinkedQueue<T>>>(d2);
        return d2;
    }

    public final void recycle(T t) {
        this.getQueue().offer(t);
    }

    protected abstract T create();

    public static final class TubePool
    extends Pool<Tube> {
        private final Tube master;

        public TubePool(Tube master) {
            this.master = master;
            this.recycle(master);
        }

        @Override
        protected Tube create() {
            return TubeCloner.clone(this.master);
        }

        @Deprecated
        public Tube takeMaster() {
            return this.master;
        }
    }

    public static final class Unmarshaller
    extends Pool<jakarta.xml.bind.Unmarshaller> {
        private final JAXBContext context;

        public Unmarshaller(JAXBContext context) {
            this.context = context;
        }

        @Override
        protected jakarta.xml.bind.Unmarshaller create() {
            try {
                return this.context.createUnmarshaller();
            }
            catch (JAXBException e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }

    public static final class Marshaller
    extends Pool<jakarta.xml.bind.Marshaller> {
        private final JAXBContext context;

        public Marshaller(JAXBContext context) {
            this.context = context;
        }

        @Override
        protected jakarta.xml.bind.Marshaller create() {
            try {
                return this.context.createMarshaller();
            }
            catch (JAXBException e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }
}

