/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util.xml;

import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentHandlerToXMLStreamWriter
extends DefaultHandler {
    private final XMLStreamWriter staxWriter;
    private final Stack prefixBindings;

    public ContentHandlerToXMLStreamWriter(XMLStreamWriter staxCore) {
        this.staxWriter = staxCore;
        this.prefixBindings = new Stack();
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.staxWriter.writeEndDocument();
            this.staxWriter.flush();
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.staxWriter.writeStartDocument();
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.staxWriter.writeCharacters(ch, start, length);
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        try {
            this.staxWriter.writeEntityRef(name);
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.staxWriter.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals("xml")) {
            return;
        }
        this.prefixBindings.add(prefix);
        this.prefixBindings.add(uri);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.staxWriter.writeEndElement();
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.staxWriter.writeStartElement(this.getPrefix(qName), localName, namespaceURI);
            while (this.prefixBindings.size() != 0) {
                String uri = (String)this.prefixBindings.pop();
                String prefix = (String)this.prefixBindings.pop();
                if (prefix.length() == 0) {
                    this.staxWriter.setDefaultNamespace(uri);
                } else {
                    this.staxWriter.setPrefix(prefix, uri);
                }
                this.staxWriter.writeNamespace(prefix, uri);
            }
            this.writeAttributes(atts);
        }
        catch (XMLStreamException e2) {
            throw new SAXException(e2);
        }
    }

    private void writeAttributes(Attributes atts) throws XMLStreamException {
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            String prefix = this.getPrefix(atts.getQName(i2));
            if (prefix.equals("xmlns")) continue;
            this.staxWriter.writeAttribute(prefix, atts.getURI(i2), atts.getLocalName(i2), atts.getValue(i2));
        }
    }

    private String getPrefix(String qName) {
        int idx = qName.indexOf(58);
        if (idx == -1) {
            return "";
        }
        return qName.substring(0, idx);
    }
}

