/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.search;

import jakarta.mail.search.ComparisonTerm;
import java.util.Date;

public abstract class DateTerm
extends ComparisonTerm {
    protected Date date;
    private static final long serialVersionUID = 4818873430063720043L;

    protected DateTerm(int comparison, Date date) {
        this.comparison = comparison;
        this.date = date;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public int getComparison() {
        return this.comparison;
    }

    protected boolean match(Date d2) {
        switch (this.comparison) {
            case 1: {
                return d2.before(this.date) || d2.equals(this.date);
            }
            case 2: {
                return d2.before(this.date);
            }
            case 3: {
                return d2.equals(this.date);
            }
            case 4: {
                return !d2.equals(this.date);
            }
            case 5: {
                return d2.after(this.date);
            }
            case 6: {
                return d2.after(this.date) || d2.equals(this.date);
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DateTerm)) {
            return false;
        }
        DateTerm dt = (DateTerm)obj;
        return dt.date.equals(this.date) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.date.hashCode() + super.hashCode();
    }
}

